<?php
session_start();
require '../../edu_digital/config/database.php';

/* ================= AMBIL TAHUN AKTIF ================= */
$tahun = $conn->query("SELECT id,tahun FROM tahun_ajaran WHERE status='aktif' LIMIT 1")->fetch_assoc();
$tahun_id = $tahun['id'];

/* ================= QUERY TOTAL PER SISWA (SUPPORT CICILAN) ================= */
$query = "
SELECT 
    s.id AS siswa_id,
    s.nama,
    CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS kelas_full,

    COALESCE(SUM(st.nominal),0) AS total_tagihan,

    COALESCE((
        SELECT SUM(sp.jumlah_bayar)
        FROM spp_pembayaran sp
        WHERE sp.siswa_id = s.id
    ),0) AS total_bayar

FROM siswa s

LEFT JOIN spp_tagihan st 
    ON st.siswa_id = s.id 
    AND st.tahun_ajaran_id = $tahun_id

LEFT JOIN kelas k ON s.kelas_id = k.id
LEFT JOIN paket p ON p.id = k.paket_id

GROUP BY s.id
ORDER BY k.nama_kelas, s.nama
";

$result = $conn->query($query);
?>
<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Tagihan SPP</title>

<style>
body{margin:0;font-family:Segoe UI;background:#f4f6f9;}
.topbar{
    background:#4e73df;color:white;padding:15px;
    display:flex;justify-content:space-between;font-weight:bold;
}
.container{padding:15px;margin-bottom:60px;}
.card{
    background:white;border-radius:12px;
    box-shadow:0 4px 15px rgba(0,0,0,.1);
    overflow:hidden;
}
table{width:100%;border-collapse:collapse;}
th,td{padding:10px;border-bottom:1px solid #eee;}
th{background:#4e73df;color:white;font-size:14px;}
tr:hover{background:#f1f1f1;cursor:pointer;}
.badge{
    padding:5px 12px;border-radius:20px;
    color:white;font-size:12px;white-space:nowrap;
}
td{ white-space:nowrap; }

.belum{background:#e74a3b;}
.lunas{background:#1cc88a;}

.modal{
    display:none;position:fixed;inset:0;
    background:rgba(0,0,0,.6);
    justify-content:center;align-items:center;
}
.modal-content{
    background:white;width:95%;max-width:500px;
    border-radius:15px;padding:20px;
    max-height:80vh;overflow:auto;
}
.btn{
    padding:6px 12px;border:none;
    border-radius:6px;cursor:pointer;
}
.btn-primary{background:#4e73df;color:white;}
.btn-success{background:#1cc88a;color:white;}
.btn-close{background:#e74a3b;color:white;}

.footer{
    position:fixed;
    bottom:0;
    width:100%;
    background:white;
    border-top:1px solid #eee;
    display:flex;
    justify-content:space-around;
    padding:8px 0;
    box-shadow:0 -4px 15px rgba(0,0,0,.05);
    z-index:999;
}

.nav-item{
    flex:1;
    text-align:center;
    text-decoration:none;
    color:#777;
    font-size:11px;
    display:flex;
    flex-direction:column;
    align-items:center;
    transition:.2s;
}

.nav-item .icon{
    font-size:20px;
    margin-bottom:2px;
    transition:.2s;
}

.nav-item.active{ color:#4e73df; }
.nav-item.active .icon{ transform:translateY(-3px); }
.nav-item:active{ transform:scale(0.95); }

@media (max-width:768px){
.card{ overflow-x:auto; }
table{ min-width:600px; }
}
</style>
</head>
<body>

<div class="topbar">
    <div>📌 Tagihan SPP</div>
    <div><?= htmlspecialchars($tahun['tahun']); ?></div>
</div>

<div class="container">
<div class="card">

<table>
<tr>
<th>Nama</th>
<th>Kelas</th>
<th>Total</th>
<th>Sisa</th>
<th>Status</th>
</tr>

<?php while($row=$result->fetch_assoc()): 

$total_tagihan = $row['total_tagihan'];
$total_bayar   = $row['total_bayar'];
$sisa_tagihan  = $total_tagihan - $total_bayar;

$status = ($sisa_tagihan > 0) ? 'belum' : 'lunas';
?>

<tr onclick="showDetail(<?= $row['siswa_id']; ?>)">
<td><?= htmlspecialchars($row['nama']); ?></td>
<td><?= rtrim($row['kelas_full'],'-'); ?></td>
<td>Rp <?= number_format($total_tagihan,0,',','.'); ?></td>
<td>Rp <?= number_format($sisa_tagihan,0,',','.'); ?></td>
<td>
<span class="badge <?= $status; ?>">
<?= $status=='belum'?'Belum Lunas':'Lunas'; ?>
</span>
</td>
</tr>

<?php endwhile; ?>

</table>

</div>
</div>

<!-- MODAL -->
<div class="modal" id="modal">
<div class="modal-content">
<h3>Rincian Tagihan</h3>
<div id="detailContent">Loading...</div>
<br>
<button class="btn btn-close" onclick="closeModal()">Tutup</button>
</div>
</div>

<div class="footer">
    <a href="index.php" class="nav-item">
        <span class="icon">🏠</span>
        <span class="label">Home</span>
    </a>

    <a href="tagihan.php" class="nav-item active">
        <span class="icon">💰</span>
        <span class="label">Tagihan</span>
    </a>

    <a href="bayar.php" class="nav-item">
        <span class="icon">🧾</span>
        <span class="label">Bayar</span>
    </a>

    <a href="laporan.php" class="nav-item">
        <span class="icon">📊</span>
        <span class="label">Laporan</span>
    </a>
</div>

<script>
let currentSiswa = null;

function showDetail(id){
    currentSiswa = id;
    document.getElementById('modal').style.display='flex';
    fetch('rincian_ajax.php?siswa='+id)
    .then(res => res.text())
    .then(data => {
        document.getElementById('detailContent').innerHTML = data;
    });
}

function closeModal(){
    document.getElementById('modal').style.display='none';
}
</script>

</body>
</html>
