<?php
session_start();

if (!isset($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../../edu_digital/auth/login.php");
    exit;
}

require '../../edu_digital/config/database.php';

/* ================= FUNCTION HELPER ================= */
function getValue($conn,$query){
    $q = mysqli_query($conn,$query);
    $d = mysqli_fetch_assoc($q);
    return $d['total'] ?? 0;
}

/* ================= STATISTIK ================= */

$total_tagihan = getValue($conn,"SELECT COUNT(*) as total FROM spp_tagihan");
$total_lunas   = getValue($conn,"SELECT COUNT(*) as total FROM spp_tagihan WHERE status='lunas'");
$total_belum   = getValue($conn,"SELECT COUNT(*) as total FROM spp_tagihan WHERE status='belum'");
$total_bayar   = getValue($conn,"SELECT SUM(jumlah_bayar) as total FROM spp_pembayaran");

/* ================= PEMASUKAN ================= */

$today_income = getValue($conn,"
    SELECT SUM(jumlah_bayar) as total
    FROM spp_pembayaran
    WHERE DATE(tanggal_bayar)=CURDATE()
");

$month_income = getValue($conn,"
    SELECT SUM(jumlah_bayar) as total
    FROM spp_pembayaran
    WHERE MONTH(tanggal_bayar)=MONTH(CURDATE())
    AND YEAR(tanggal_bayar)=YEAR(CURDATE())
");

$year_income = getValue($conn,"
    SELECT SUM(jumlah_bayar) as total
    FROM spp_pembayaran
    WHERE YEAR(tanggal_bayar)=YEAR(CURDATE())
");

/* ================= GRAFIK ================= */

$grafik = [];
for($i=1;$i<=12;$i++){
    $grafik[] = getValue($conn,"
        SELECT SUM(jumlah_bayar) as total
        FROM spp_pembayaran
        WHERE MONTH(tanggal_bayar)=$i
        AND YEAR(tanggal_bayar)=YEAR(CURDATE())
    ");
}

/* ================= TUNGGAKAN ================= */

$total_tunggakan = $total_belum;

$top_siswa = mysqli_query($conn,"
    SELECT s.nama, COUNT(t.id) as jumlah_tunggakan
    FROM spp_tagihan t
    JOIN siswa s ON t.siswa_id=s.id
    WHERE t.status='belum'
    GROUP BY t.siswa_id
    ORDER BY jumlah_tunggakan DESC
    LIMIT 5
");

$total_all = $total_lunas + $total_belum;
$persen_lunas = $total_all > 0 ? ($total_lunas/$total_all)*100 : 0;
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard SPP</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
    background:#f4f6f9;
    padding-bottom:90px;
}

.topbar{
    background:linear-gradient(135deg,#1e3c72,#2a5298);
    color:white;
    padding:16px;
    border-radius:0 0 20px 20px;
}

.stat-card{
    border-radius:18px;
    transition:.3s;
}
.stat-card:hover{
    transform:translateY(-5px);
    box-shadow:0 10px 20px rgba(0,0,0,.15);
}

.bottom-menu{
    position:fixed;
    bottom:0;
    left:0;
    right:0;
    background:#fff;
    border-top:1px solid #ddd;
    display:flex;
    justify-content:space-around;
    padding:8px 0;
    z-index:999;
}

.bottom-menu a{
    text-decoration:none;
    color:#555;
    font-size:12px;
    text-align:center;
}

.bottom-menu i{
    font-size:20px;
    display:block;
}

.bottom-menu a.active{
    color:#0d6efd;
}
</style>
</head>

<body>

<!-- ================= TOPBAR ================= -->
<div class="topbar d-flex justify-content-between align-items-center">
    <div>
        <h5 class="mb-0">Manajemen SPP</h5>
        <small>Halo, <?= $_SESSION['user']['nama']; ?> 👋</small>
    </div>

    <div>
        <i class="bi bi-bell fs-4 position-relative">
            <?php if($total_tunggakan > 0): ?>
                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                    <?= $total_tunggakan ?>
                </span>
            <?php endif; ?>
        </i>
    </div>
</div>

<div class="container mt-4">

<!-- ================= KPI ================= -->
<div class="row g-3 mb-4">

    <div class="col-6 col-md-3">
        <div class="card stat-card text-white p-3 text-center"
             style="background:linear-gradient(135deg,#11998e,#38ef7d)">
            <i class="bi bi-check-circle fs-4"></i>
            <h5><?= $total_lunas ?></h5>
            <small>Lunas</small>
        </div>
    </div>

    <div class="col-6 col-md-3">
        <div class="card stat-card text-white p-3 text-center"
             style="background:linear-gradient(135deg,#f85032,#e73827)">
            <i class="bi bi-x-circle fs-4"></i>
            <h5><?= $total_belum ?></h5>
            <small>Belum</small>
        </div>
    </div>

    <div class="col-6 col-md-3">
        <div class="card stat-card text-white p-3 text-center"
             style="background:linear-gradient(135deg,#1e3c72,#2a5298)">
            <i class="bi bi-receipt fs-4"></i>
            <h5><?= $total_tagihan ?></h5>
            <small>Tagihan</small>
        </div>
    </div>

    <div class="col-6 col-md-3">
        <div class="card stat-card text-white p-3 text-center"
             style="background:linear-gradient(135deg,#7b4397,#dc2430)">
            <i class="bi bi-cash-stack fs-4"></i>
            <h6>Rp <?= number_format($total_bayar,0,',','.') ?></h6>
            <small>Pemasukan</small>
        </div>
    </div>

</div>

<!-- ================= INCOME ================= -->
<div class="row g-3 mb-4">
    <div class="col-md-4">
        <div class="card shadow-sm border-0 p-3">
            <h6 class="text-muted">Hari Ini</h6>
            <h4 class="text-success fw-bold">Rp <?= number_format($today_income,0,',','.') ?></h4>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card shadow-sm border-0 p-3">
            <h6 class="text-muted">Bulan Ini</h6>
            <h4 class="text-primary fw-bold">Rp <?= number_format($month_income,0,',','.') ?></h4>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card shadow-sm border-0 p-3">
            <h6 class="text-muted">Tahun Ini</h6>
            <h4 class="text-danger fw-bold">Rp <?= number_format($year_income,0,',','.') ?></h4>
        </div>
    </div>
</div>

<!-- ================= PROGRESS + DONUT ================= -->
<div class="row g-3 mb-4">

    <div class="col-md-6">
        <div class="card shadow-sm border-0 p-4">
            <h6>Progress Pembayaran</h6>
            <div class="progress" style="height:25px;">
                <div class="progress-bar bg-success"
                     style="width: <?= $persen_lunas ?>%">
                     <?= round($persen_lunas) ?>% Lunas
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card shadow-sm border-0 p-4">
            <h6>Lunas vs Belum</h6>
            <canvas id="donutChart"></canvas>
        </div>
    </div>

</div>

<!-- ================= TOP 5 ================= -->
<div class="card shadow-sm border-0 p-4 mb-4">
    <h6 class="mb-3">Top 5 Siswa Menunggak</h6>
    <ul class="list-group list-group-flush">
        <?php while($row=mysqli_fetch_assoc($top_siswa)): ?>
        <li class="list-group-item d-flex justify-content-between">
            <?= $row['nama']; ?>
            <span class="badge bg-danger">
                <?= $row['jumlah_tunggakan']; ?> bulan
            </span>
        </li>
        <?php endwhile; ?>
    </ul>
</div>

<!-- ================= GRAFIK ================= -->
<div class="card shadow-sm border-0 p-4">
    <h6>Grafik Pemasukan <?= date('Y') ?></h6>
    <canvas id="chartSPP"></canvas>
</div>

</div>

<!-- ================= BOTTOM MENU ================= -->
<div class="bottom-menu">
    <a href="index.php" class="active"><i class="bi bi-house-door"></i>Home</a>
    <a href="tagihan.php"><i class="bi bi-journal-text"></i>Tagihan</a>
    <a href="bayar.php"><i class="bi bi-credit-card"></i>Input</a>
    <a href="laporan.php"><i class="bi bi-bar-chart"></i>Laporan</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
new Chart(document.getElementById('chartSPP'), {
    type: 'line',
    data: {
        labels: ['Jan','Feb','Mar','Apr','Mei','Jun','Jul','Agu','Sep','Okt','Nov','Des'],
        datasets: [{
            label: 'Pemasukan',
            data: <?= json_encode($grafik) ?>,
            borderWidth: 3,
            tension: 0.4,
            fill: true
        }]
    },
    options: { responsive:true }
});

new Chart(document.getElementById('donutChart'), {
    type: 'doughnut',
    data: {
        labels: ['Lunas','Belum'],
        datasets: [{
            data: [<?= $total_lunas ?>, <?= $total_belum ?>]
        }]
    },
    options:{ responsive:true }
});
</script>

</body>
</html>
