<?php
session_start();
require __DIR__ . '/../config/database.php';

$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2) die("Koneksi PKBM gagal");

// ================= PROTEKSI =================
if (
    empty($_SESSION['login_siswa']) || 
    empty($_SESSION['ujian']['id_ujian']) || 
    empty($_SESSION['siswa']['id'])
) {
    header("Location: ../siswa/biodata_siswa.php");
    exit;
}

$id_ujian      = (int)$_SESSION['ujian']['id_ujian'];
$id_siswa_cbt  = (int)$_SESSION['siswa']['id'];


// ================= UPDATE STATUS =================
mysqli_query($conn,"
    UPDATE login_siswa 
    SET status='mengerjakan', last_active=NOW()
    WHERE id_siswa=$id_siswa_cbt AND id_ujian=$id_ujian
");

// ================= AMBIL DATA UJIAN =================
$ujian_res = mysqli_query($conn,"SELECT * FROM ujian WHERE id=$id_ujian LIMIT 1");
if(!$ujian_res || !mysqli_num_rows($ujian_res)){
    header("Location: ../siswa/biodata_siswa.php");
    exit;
}
$ujian = mysqli_fetch_assoc($ujian_res);
$durasi_detik = ((int)$ujian['durasi']) * 60; // durasi dalam detik

// ================= AMBIL SOAL =================
$soal_res = mysqli_query($conn,"SELECT * FROM soal WHERE id_ujian=$id_ujian ORDER BY id ASC");
$total_soal = mysqli_num_rows($soal_res);

// ================= AMBIL DATA SISWA PKBM =================
$id_siswa_pkbm = (int)($_SESSION['siswa']['id_pkbm'] ?? $_SESSION['siswa']['id'] ?? 0);

if(!$id_siswa_pkbm){
    die("SESSION SISWA PKBM TIDAK TERDETEKSI");
}

$stmt = mysqli_prepare($conn2,"
    SELECT s.id, s.nisn, s.nama, s.kelas_id, k.nama_kelas, k.paket_id
    FROM siswa s
    JOIN kelas k ON k.id = s.kelas_id
    WHERE s.id = ?
    LIMIT 1
");
mysqli_stmt_bind_param($stmt,"i",$id_siswa_pkbm);
mysqli_stmt_execute($stmt);
$res_siswa = mysqli_stmt_get_result($stmt);
$siswa = mysqli_fetch_assoc($res_siswa);
mysqli_stmt_close($stmt);

// ================= HTML =================
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ujian CBT - <?= htmlspecialchars($ujian['nama_ujian']) ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.card{border-radius:14px}
.soal{display:none}
.soal.active{display:block}
.opsi label{display:block;padding:10px;border:1px solid #ddd;border-radius:8px;margin-bottom:8px;cursor:pointer}
.opsi input{display:none}
.opsi input:checked + label{background:#e7f1ff;border-color:#0d6efd;font-weight:bold}
.nav-btm{position:sticky;bottom:0;background:#fff;padding:10px;border-top:1px solid #ddd}
.timer{font-weight:bold}
/* Webcam Monitoring */
.cam-box{position:fixed;top:12px;left:12px;width:120px;height:90px;background:#000;border:2px solid #dc3545;border-radius:10px;overflow:hidden;z-index:99999;box-shadow:0 4px 10px rgba(0,0,0,.4)}
.cam-box video{width:100%;height:100%;object-fit:cover;transform:scaleX(-1)}
.cam-label{position:absolute;bottom:0;left:0;right:0;font-size:10px;background:rgba(220,53,69,.85);color:#fff;text-align:center;padding:1px 0}
@media (max-width: 576px){.cam-box{width:100px;height:75px}}
</style>
</head>
<body>

<nav class="navbar bg-white shadow-sm mb-3">
<div class="container">
<b><?= htmlspecialchars($ujian['nama_ujian']) ?></b>
</div>
</nav>

<!-- MONITOR WEBCAM -->
<div class="cam-box">
 <video id="cam" autoplay muted playsinline></video>
 <div class="cam-label">📷 Monitoring</div>
</div>

<div class="container mb-5">
<div class="alert alert-warning text-center">
⏱️ Ujian: <span id="timerUjian" class="timer">--:--</span> |
⏳ Soal: <span id="timerSoal" class="timer">01:30</span>
</div>

<form method="post" action="selesai.php" id="formUjian">

<?php
$no=1;
while($s=mysqli_fetch_assoc($soal_res)):
    $opsi_asli = array_filter([$s['a'],$s['b'],$s['c'],$s['d'],$s['e']]);
    $opsi = ['A'=>null,'B'=>null,'C'=>null,'D'=>null,'E'=>null];

    // Acak opsi jika PG
    if(($s['tipe'] ?? 'pg')=='pg'){
        $cek = mysqli_query($conn,"
            SELECT huruf_tampil,huruf_asli 
            FROM acak_opsi
            WHERE id_siswa=$id_siswa_cbt AND id_soal={$s['id']}
        ");
        if(mysqli_num_rows($cek)){
            while($a=mysqli_fetch_assoc($cek)){
                if(isset($opsi_asli[$a['huruf_asli']])) $opsi[$a['huruf_tampil']] = $opsi_asli[$a['huruf_asli']];
            }
        } else {
            $isi = array_values($opsi_asli); shuffle($isi); $i=0;
            foreach($opsi as $h=>$v){
                if(!isset($isi[$i])) continue;
                $opsi[$h] = $isi[$i];
                $asli = array_search($isi[$i],$opsi_asli,true);
                mysqli_query($conn,"
                    INSERT INTO acak_opsi (id_siswa,id_soal,huruf_tampil,huruf_asli)
                    VALUES ($id_siswa_cbt,{$s['id']},'$h','$asli')
                ");
                $i++;
            }
        }
    }
?>

<div class="card mb-4 soal" id="soal<?= $no ?>">
<div class="card-body">
<b>Soal <?= $no ?> / <?= $total_soal ?></b>
<p><?= nl2br(htmlspecialchars($s['soal'])) ?></p>

<?php if(($s['tipe'] ?? 'pg')=='pg'): ?>
<div class="opsi">
<?php foreach($opsi as $h=>$isi): if($isi): ?>
<input type="radio" id="j<?= $s['id'].$h ?>" name="jawaban[<?= $s['id'] ?>]" value="<?= $h ?>">
<label for="j<?= $s['id'].$h ?>"><b><?= $h ?>.</b> <?= htmlspecialchars($isi) ?></label>
<?php endif; endforeach; ?>
</div>
<?php else: ?>
<textarea name="jawaban_essay[<?= $s['id'] ?>]" class="form-control" rows="5" required></textarea>
<?php endif; ?>

</div></div>
<?php $no++; endwhile; ?>

<div class="nav-btm d-flex gap-2 justify-content-between">
<button type="button" class="btn btn-secondary" onclick="prevSoal()">⬅️</button>
<button type="button" class="btn btn-warning" onclick="kirimJawaban()">📩</button>
<button type="button" class="btn btn-primary" onclick="nextSoal()">➡️</button>
</div>

<button type="submit" id="btnFinish" class="btn btn-danger w-100 mt-4 fw-bold" disabled>🚩 SELESAIKAN UJIAN</button>
</form>
</div>

<canvas id="snap" style="display:none"></canvas>

<script>
// ================= NAV + STATUS =================
let idx=1;
let total=document.querySelectorAll('.soal').length;

function showSoal(){
 document.querySelectorAll('.soal').forEach(s=>s.classList.remove('active'));
 document.getElementById('soal'+idx).classList.add('active');
 cekSemuaSoal();
}
showSoal();

function sudahJawab(){
 let s=document.getElementById('soal'+idx);
 let r=s.querySelectorAll('input[type=radio]');
 if(r.length) return s.querySelector('input[type=radio]:checked')!==null;
 let t=s.querySelector('textarea');
 return t && t.value.trim()!=='';
}

function cekSemuaSoal(){
 let selesai=true;
 for(let i=1;i<=total;i++){
  let s=document.getElementById('soal'+i);
  let r=s.querySelectorAll('input[type=radio]');
  if(r.length){if(!s.querySelector('input[type=radio]:checked')) selesai=false;}
  else {let t=s.querySelector('textarea'); if(!t || t.value.trim()==='') selesai=false;}
 }
 document.getElementById('btnFinish').disabled=!selesai;
}

function nextSoal(){if(!sudahJawab()) return alert('Jawab soal dulu'); if(idx<total){idx++;showSoal();}}
function prevSoal(){ if(idx>1){idx--;showSoal();} }
function kirimJawaban(){

    let form = document.getElementById('formUjian');
    let data = new FormData(form);

    fetch('simpan_jawaban.php',{
        method:'POST',
        body:data
    })
    .then(r=>r.text())
    .then(r=>{
        console.log(r);
        alert('Jawaban berhasil disimpan');
        if(idx<total){ idx++; showSoal(); }
    })
    .catch(()=>alert('Gagal simpan jawaban'));
}


document.addEventListener('change',cekSemuaSoal);
document.addEventListener('keyup',cekSemuaSoal);

// ================= TIMER =================
let totalUjian=<?= $durasi_detik ?>;
let waktuSoal=90;
let sisaSoal=waktuSoal;

function format(d){ let m=Math.floor(d/60), s=d%60; return m.toString().padStart(2,'0')+':'+s.toString().padStart(2,'0');}
function resetSoal(){sisaSoal=waktuSoal;}

setInterval(()=>{
 totalUjian--; sisaSoal--;
 document.getElementById('timerUjian').innerText=format(totalUjian);
 document.getElementById('timerSoal').innerText=format(sisaSoal);

 if(sisaSoal<=0){ if(idx<total){idx++;resetSoal();showSoal();} }
 if(totalUjian<=0){ alert('⏰ Waktu ujian habis'); document.getElementById('formUjian').submit(); }
},1000);

// ================= HEARTBEAT =================
setInterval(()=>fetch('heartbeat.php'),30000);

// ================= PELANGGARAN =================
let last=0;
function lapor(j){if(Date.now()-last<3000) return; last=Date.now(); fetch('lapor_pelanggaran.php',{method:'POST', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body:'jenis='+encodeURIComponent(j)}); alert('⚠️ Pelanggaran terdeteksi');}
document.addEventListener('visibilitychange',()=>{if(document.hidden)lapor('Pindah Tab')});
window.addEventListener('beforeunload',e=>{lapor('Refresh');e.returnValue='';});

// ================= WEBCAM =================
const video=document.getElementById('cam');
const canvas=document.getElementById('snap');
const ctx=canvas.getContext('2d');

navigator.mediaDevices.getUserMedia({video:true}).then(s=>video.srcObject=s).catch(()=>console.warn('kamera ditolak'));

function foto(k){if(!video.videoWidth) return; canvas.width=video.videoWidth; canvas.height=video.videoHeight; ctx.drawImage(video,0,0); fetch('webcam_capture.php',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:'image='+encodeURIComponent(canvas.toDataURL('image/jpeg'))+'&keterangan='+k});}
setTimeout(()=>foto('mulai ujian'),3000);
setInterval(()=>foto('monitor rutin'),300000);
</script>

</body>
</html>
