CREATE TABLE login_siswa (
  id INT AUTO_INCREMENT PRIMARY KEY,

  id_siswa INT NOT NULL,
  id_ujian INT NOT NULL,

  status ENUM(
    'login',
    'mengerjakan',
    'selesai'
  ) DEFAULT 'login',

  last_active DATETIME DEFAULT NULL,
  login_time DATETIME DEFAULT CURRENT_TIMESTAMP,
  logout_time DATETIME DEFAULT NULL,

  force_logout TINYINT(1) DEFAULT 0,

  UNIQUE KEY uniq_siswa_ujian (id_siswa, id_ujian),

  INDEX idx_last_active (last_active),
  INDEX idx_status (status),

  CONSTRAINT fk_login_siswa_siswa
    FOREIGN KEY (id_siswa) REFERENCES siswa(id)
    ON DELETE CASCADE,

  CONSTRAINT fk_login_siswa_ujian
    FOREIGN KEY (id_ujian) REFERENCES ujian(id)
    ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
