<?php
require __DIR__ . '/../config/database.php'; // $conn = SMART CBT
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani"); // $conn2 = PKBM

if(!$conn2) die("Koneksi database pkbm gagal: ".mysqli_connect_error());

// SESSION
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

// CONFIG TOKEN
$expired = 1800; // 30 menit

// PROFIL
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach($tables as $t){
    $c=mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if($c && mysqli_num_rows($c)){
        $q=mysqli_query($conn,"SELECT * FROM $t LIMIT 1");
        if($q && mysqli_num_rows($q)){
            $s=mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi']??$nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah']??$nama_sekolah;
            $logo          = $s['logo']??$logo;
        }
        break;
    }
}
if(!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

// GENERATE MANUAL TOKEN
if(isset($_POST['buat'])){
    $id = (int)$_POST['id_ujian'];
    mysqli_query($conn,"DELETE FROM token WHERE id_ujian=$id");

    $token = strtoupper(substr(bin2hex(random_bytes(4)),0,6));
    mysqli_query($conn,"INSERT INTO token (id_ujian, token, aktif, created_at)
                        VALUES ($id,'$token','Y',NOW())");

    header("Location: token.php");
    exit;
}

// ===== QUERY UTAMA (JOIN LINTAS DATABASE) =====
$q = mysqli_query($conn,"
SELECT 
    u.id,
    u.nama_ujian,
    k.nama_kelas,
    k.paket_id,
    m.nama_mapel,
    t.token,
    TIMESTAMPDIFF(SECOND, t.created_at, NOW()) AS umur
FROM ujian u
LEFT JOIN token t 
    ON t.id_ujian = u.id AND t.aktif='Y'
LEFT JOIN pkbm_taruna_qurani.kelas k 
    ON k.id = u.id_kelas
LEFT JOIN pkbm_taruna_qurani.mapel m 
    ON m.id = u.id_mapel
WHERE u.status='Aktif'
ORDER BY u.id DESC
");

$ujian_list = [];
while($u = mysqli_fetch_assoc($q)){
    $u['nama_kelas'] = $u['nama_kelas']
        ? $u['nama_kelas'].'-'.chr(64+$u['paket_id'])
        : '-';
    $ujian_list[] = $u;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Token Ujian</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:linear-gradient(135deg,#eef2ff,#f8fafc);font-family:'Segoe UI',sans-serif;}
.sidebar{width:260px;min-height:100vh;background:#0f172a;color:#fff;position:fixed;}
.brand{padding:16px;background:#020617;display:flex;gap:12px;align-items:center;}
.brand img{width:38px}
.sidebar a{color:#cbd5e1;padding:11px 18px;display:block;text-decoration:none;border-radius:8px;margin:4px 10px;}
.sidebar a.active,.sidebar a:hover{background:#2563eb;color:#fff;}
.submenu a{margin-left:20px;font-size:14px}
.content{margin-left:260px;padding:30px;}
.token-card{border:none;border-radius:18px;background:#fff;box-shadow:0 10px 25px rgba(0,0,0,.08);}
.token-box{font-size:32px;font-weight:800;letter-spacing:6px;color:#dc2626;background:#fee2e2;border-radius:12px;padding:12px 0;margin:12px 0;}
.footer-fixed{position:fixed;bottom:10px;right:16px;font-size:13px;color:#000;}
</style>
</head>
<body>

<div class="sidebar">
<div class="brand">
<img src="../assets/logo/<?= $logo ?>">
<div>
<b><?= $nama_aplikasi ?></b><br>
<small><?= $nama_sekolah ?></small>
</div>
</div>

<a href="dashboard.php">🏠 Dashboard</a>

<a data-bs-toggle="collapse" href="#ujian">
📝 Ujian <span class="float-end">▼</span>
</a>
<div class="collapse show submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php" class="active">🔑 Token</a>
</div>

<a href="../auth/logout.php">🚪 Logout</a>
</div>

<div class="content">
<h4 class="fw-bold mb-4">🔑 Token Ujian</h4>

<div class="row">
<?php foreach($ujian_list as $u): ?>
<div class="col-md-4 mb-4">
  <div class="card token-card">
    <div class="card-body text-center">
      <h6 class="fw-bold"><?= htmlspecialchars($u['nama_ujian']) ?></h6>
      <small class="text-muted">
        Kelas <?= htmlspecialchars($u['nama_kelas']) ?> ·
        <?= htmlspecialchars($u['nama_mapel']) ?>
      </small>

      <div class="token-box"><?= $u['token'] ?: '------' ?></div>

      <small class="text-muted d-block mb-2">
        Berlaku ± <?= max(0,ceil(($expired-$u['umur'])/60)) ?> menit
      </small>

      <form method="post" onsubmit="return confirm('Generate token baru?')">
        <input type="hidden" name="id_ujian" value="<?= $u['id'] ?>">
        <button name="buat" class="btn btn-danger w-100">🔄 Generate Manual</button>
      </form>
    </div>
  </div>
</div>
<?php endforeach; ?>
</div>
</div>

<div class="footer-fixed">Dibuat Oleh : <b>Bang Zae</b></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
