<?php
require __DIR__ . '/../config/database.php';

/* ================= SESSION ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL SEKOLAH AUTO ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach ($tables as $t) {
    $c = mysqli_query($conn, "SHOW TABLES LIKE '$t'");
    if ($c && mysqli_num_rows($c)) {
        $q = mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if ($q && mysqli_num_rows($q)) {
            $s = mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah'] ?? $nama_sekolah;
            $logo          = $s['logo'] ?? $logo;
        }
        break;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= CRUD ================= */

// TAMBAH
if (isset($_POST['tambah'])) {
    $tahun = mysqli_real_escape_string($conn, $_POST['tahun']);
    $aktif = $_POST['aktif'];

    if ($aktif === 'Y') {
        mysqli_query($conn, "UPDATE tahun_pelajaran SET aktif='N'");
    }

    mysqli_query($conn, "INSERT INTO tahun_pelajaran (tahun, aktif)
                          VALUES ('$tahun','$aktif')");
    header("Location: tahun.php");
    exit;
}

// EDIT
if (isset($_POST['edit'])) {
    $id    = (int)$_POST['id'];
    $tahun = mysqli_real_escape_string($conn, $_POST['tahun']);
    $aktif = $_POST['aktif'];

    if ($aktif === 'Y') {
        mysqli_query($conn, "UPDATE tahun_pelajaran SET aktif='N'");
    }

    mysqli_query($conn, "UPDATE tahun_pelajaran
                          SET tahun='$tahun', aktif='$aktif'
                          WHERE id=$id");
    header("Location: tahun.php");
    exit;
}

// HAPUS (HANYA JIKA NONAKTIF)
if (isset($_GET['hapus'])) {
    $id = (int)$_GET['hapus'];
    $cek = mysqli_query($conn, "SELECT aktif FROM tahun_pelajaran WHERE id=$id");
    $r = mysqli_fetch_assoc($cek);

    if ($r && $r['aktif'] === 'N') {
        mysqli_query($conn, "DELETE FROM tahun_pelajaran WHERE id=$id");
    }

    header("Location: tahun.php");
    exit;
}

$data = mysqli_query($conn, "SELECT * FROM tahun_pelajaran ORDER BY id DESC");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Tahun Pelajaran</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
  background:#f4f6f9;
  font-family:Inter,system-ui,-apple-system,sans-serif;
}

/* ===== SIDEBAR ===== */
.sidebar{
  width:260px;
  height:100vh;
  background:#0f172a;
  position:fixed;
  top:0; left:0;
}
.brand{
  padding:18px;
  display:flex;
  gap:12px;
  align-items:center;
  border-bottom:1px solid rgba(255,255,255,.1);
}
.brand img{width:42px}
.brand small{color:#94a3b8}

.sidebar a{
  color:#cbd5e1;
  display:flex;
  align-items:center;
  gap:10px;
  padding:11px 18px;
  text-decoration:none;
  font-size:14px;
}
.sidebar a:hover{background:#1e293b;color:#fff}
.sidebar a.active{background:#2563eb;color:#fff;font-weight:500}
.menu-title{
  padding:12px 18px;
  font-size:11px;
  text-transform:uppercase;
  color:#64748b;
}

/* ===== CONTENT ===== */
.main{
  margin-left:260px;
  padding:25px;
}

/* ===== CARD & TABLE ===== */
.card{
  border:0;
  border-radius:14px;
  box-shadow:0 10px 30px rgba(0,0,0,.08);
}
.card-header{
  background:#fff;
  border-bottom:1px solid #e5e7eb;
  padding:16px 20px;
}
.table th{
  font-size:12px;
  text-transform:uppercase;
  color:#64748b;
  background:#f8fafc;
}
.table-hover tbody tr:hover{background:#f1f5f9}
.badge{
  padding:6px 14px;
  border-radius:20px;
  font-size:12px;
}
.modal-content{
  border-radius:14px;
  border:0;
  box-shadow:0 20px 40px rgba(0,0,0,.35);
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <b><?= htmlspecialchars($nama_aplikasi) ?></b><br>
      <small><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>
  <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
    <a href="kelas.php">🏫 Kelas</a>
    <a href="mapel.php">📘 Mata Pelajaran</a>
    <a href="siswa.php">👨‍🎓 Siswa</a>
    <a href="tahun.php">📅 Tahun Pelajaran</a>
  </div>

  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

<!-- ===== CONTENT ===== -->
<div class="main">
  <div class="card">
    <div class="card-header d-flex justify-content-between">
      <h5 class="mb-0">Tahun Pelajaran</h5>
      <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#tambah">
        <i class="bi bi-plus"></i> Tambah
      </button>
    </div>

    <div class="card-body">
      <table class="table table-hover table-bordered align-middle">
        <thead>
          <tr>
            <th width="50">No</th>
            <th>Tahun</th>
            <th>Status</th>
            <th width="140">Aksi</th>
          </tr>
        </thead>
        <tbody>
        <?php $no=1; while($r=mysqli_fetch_assoc($data)): ?>
          <tr>
            <td><?= $no++ ?></td>
            <td><strong><?= htmlspecialchars($r['tahun']) ?></strong></td>
            <td>
              <?= $r['aktif']=='Y'
                  ? '<span class="badge bg-success">Aktif</span>'
                  : '<span class="badge bg-secondary">Nonaktif</span>' ?>
            </td>
            <td>
              <button class="btn btn-warning btn-sm"
                data-bs-toggle="modal"
                data-bs-target="#edit<?= $r['id'] ?>">
                <i class="bi bi-pencil"></i>
              </button>

              <?php if ($r['aktif']=='N'): ?>
              <a href="?hapus=<?= $r['id'] ?>"
                 onclick="return confirm('Hapus data?')"
                 class="btn btn-danger btn-sm">
                 <i class="bi bi-trash"></i>
              </a>
              <?php endif; ?>
            </td>
          </tr>
        <?php endwhile ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- ===== MODAL EDIT ===== -->
<?php mysqli_data_seek($data,0); while($r=mysqli_fetch_assoc($data)): ?>
<div class="modal fade" id="edit<?= $r['id'] ?>" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5>Edit Tahun Pelajaran</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" value="<?= $r['id'] ?>">
        <input name="tahun" class="form-control mb-2"
               value="<?= htmlspecialchars($r['tahun']) ?>" required>
        <select name="aktif" class="form-control">
          <option value="Y" <?= $r['aktif']=='Y'?'selected':'' ?>>Aktif</option>
          <option value="N" <?= $r['aktif']=='N'?'selected':'' ?>>Nonaktif</option>
        </select>
      </div>
      <div class="modal-footer">
        <button name="edit" class="btn btn-primary">Simpan</button>
      </div>
    </form>
  </div>
</div>
<?php endwhile ?>

<!-- ===== MODAL TAMBAH ===== -->
<div class="modal fade" id="tambah" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5>Tambah Tahun Pelajaran</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input name="tahun" placeholder="2025 / 2026" class="form-control mb-2" required>
        <select name="aktif" class="form-control">
          <option value="Y">Aktif</option>
          <option value="N" selected>Nonaktif</option>
        </select>
      </div>
      <div class="modal-footer">
        <button name="tambah" class="btn btn-primary">Simpan</button>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
