<?php
require __DIR__ . '/../config/database.php';
session_start();

/* ================= AUTH ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$q = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $logo         = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= HELPER ================= */
function esc($c,$s){
    return mysqli_real_escape_string($c, trim($s));
}
function passFromDate($tgl){
    return date('dmY', strtotime($tgl));
}
function generateUsername($nisn){
    $nisn = preg_replace('/\D/','',$nisn);
    return 'MTS'.substr($nisn,-5).'U';
}

/* ================= TAMBAH ================= */
if (isset($_POST['simpan'])) {

    $nisn   = esc($conn,$_POST['nisn']);
    $nama   = esc($conn,$_POST['nama']);
    $jk     = $_POST['jk'];
    $tmp    = esc($conn,$_POST['tempat_lahir']);
    $tgl    = $_POST['tanggal_lahir'];
    $kelas  = esc($conn,$_POST['kelas']);
    $status = esc($conn,$_POST['status']);

    $cek = mysqli_query($conn,"SELECT id FROM siswa WHERE nisn='$nisn'");
    if (mysqli_num_rows($cek)) {
        die('NISN sudah terdaftar');
    }

    $username = generateUsername($nisn);
    $password = password_hash(passFromDate($tgl), PASSWORD_DEFAULT);

    mysqli_query($conn,"
        INSERT INTO siswa
        (nisn,username,nama,jk,tempat_lahir,tanggal_lahir,kelas,password,status)
        VALUES
        ('$nisn','$username','$nama','$jk','$tmp','$tgl','$kelas','$password','$status')
    ");

    header("Location:siswa.php");
    exit;
}

/* ================= UPDATE ================= */
if (isset($_POST['update'])) {

    $id     = (int)$_POST['id'];
    $nisn   = esc($conn,$_POST['nisn']);
    $nama   = esc($conn,$_POST['nama']);
    $jk     = $_POST['jk'];
    $tmp    = esc($conn,$_POST['tempat_lahir']);
    $tgl    = $_POST['tanggal_lahir'];
    $kelas  = esc($conn,$_POST['kelas']);
    $status = esc($conn,$_POST['status']);

    $username = generateUsername($nisn);

    $sql = "UPDATE siswa SET
        nisn='$nisn',
        username='$username',
        nama='$nama',
        jk='$jk',
        tempat_lahir='$tmp',
        tanggal_lahir='$tgl',
        kelas='$kelas',
        status='$status'";

    if (!empty($_POST['reset_password'])) {
        $pass = password_hash(passFromDate($tgl), PASSWORD_DEFAULT);
        $sql .= ", password='$pass'";
    }

    $sql .= " WHERE id=$id";
    mysqli_query($conn,$sql);

    header("Location:siswa.php");
    exit;
}

/* ================= RESET PASSWORD ================= */
if (isset($_POST['reset_password_only'])) {

    $id = (int)$_POST['id'];
    $q  = mysqli_fetch_assoc(mysqli_query(
        $conn,"SELECT tanggal_lahir FROM siswa WHERE id=$id"
    ));

    $pass = password_hash(passFromDate($q['tanggal_lahir']), PASSWORD_DEFAULT);
    mysqli_query($conn,"UPDATE siswa SET password='$pass' WHERE id=$id");

    header("Location:siswa.php");
    exit;
}

/* ================= HAPUS ================= */
if (isset($_POST['hapus'])) {

    $id = (int)$_POST['hapus_id'];
    mysqli_query($conn,"DELETE FROM siswa WHERE id=$id");

    header("Location:siswa.php");
    exit;
}

/* ================= DATA ================= */
$siswa = mysqli_query($conn,"SELECT * FROM siswa ORDER BY nama");
$kelas = mysqli_query($conn,"SELECT * FROM kelas ORDER BY nama_kelas");
$kelasArr=[];
while($k=mysqli_fetch_assoc($kelas)) $kelasArr[]=$k;
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Siswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.submenu a{padding-left:42px;font-size:14px}
.content{margin-left:260px;padding:24px}
/* FOOTER */
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#000;
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <b><?= htmlspecialchars($nama_aplikasi) ?></b><br>
      <small><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>

  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
    <a href="mapel.php">📘 Mata Pelajaran</a>
    <a href="siswa.php">👨‍🎓 Siswa</a>
    <a href="kelas.php">🏫 Kelas</a>
    <a href="tahun.php">📅 Tahun Pelajaran</a>
  </div>
  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

<!-- CONTENT -->
<div class="content">
<h4>Data Siswa</h4>

<button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#tambah">
<i class="bi bi-plus"></i> Tambah Siswa
</button>

<table class="table table-bordered bg-white">
<tr class="table-light text-center">
<th>No</th><th>NISN</th><th>Username</th><th>Nama</th>
<th>Kelas</th><th>Status</th><th width="160">Aksi</th>
</tr>

<?php $no=1; while($s=mysqli_fetch_assoc($siswa)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= $s['nisn'] ?></td>
<td><b><?= $s['username'] ?></b></td>
<td><?= $s['nama'] ?></td>
<td class="text-center"><?= $s['kelas'] ?></td>
<td class="text-center"><?= $s['status'] ?></td>
<td class="text-center">
<button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?= $s['id'] ?>"><i class="bi bi-pencil"></i></button>
<button class="btn btn-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#pass<?= $s['id'] ?>"><i class="bi bi-key"></i></button>
<button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#hapus<?= $s['id'] ?>"><i class="bi bi-trash"></i></button>
</td>
</tr>
<?php endwhile; ?>
</table>
</div>

<?php mysqli_data_seek($siswa,0); while($s=mysqli_fetch_assoc($siswa)): ?>

<!-- EDIT -->
<div class="modal fade" id="edit<?= $s['id'] ?>">
<div class="modal-dialog">
<form method="post" class="modal-content p-3">
<input type="hidden" name="id" value="<?= $s['id'] ?>">
<h5>Edit Siswa</h5>
<input name="nisn" class="form-control mb-2" value="<?= $s['nisn'] ?>" required>
<input name="nama" class="form-control mb-2" value="<?= $s['nama'] ?>" required>
<select name="jk" class="form-select mb-2">
<option value="L" <?= $s['jk']=='L'?'selected':'' ?>>Laki-laki</option>
<option value="P" <?= $s['jk']=='P'?'selected':'' ?>>Perempuan</option>
</select>
<input name="tempat_lahir" class="form-control mb-2" value="<?= $s['tempat_lahir'] ?>" required>
<input type="date" name="tanggal_lahir" class="form-control mb-2" value="<?= $s['tanggal_lahir'] ?>" required>
<select name="kelas" class="form-select mb-2">
<?php foreach($kelasArr as $k): ?>
<option value="<?= $k['nama_kelas'] ?>" <?= $s['kelas']==$k['nama_kelas']?'selected':'' ?>>
<?= $k['nama_kelas'] ?>
</option>
<?php endforeach; ?>
</select>
<select name="status" class="form-select mb-2">
<option value="Aktif" <?= $s['status']=='Aktif'?'selected':'' ?>>Aktif</option>
<option value="Nonaktif" <?= $s['status']=='Nonaktif'?'selected':'' ?>>Nonaktif</option>
</select>
<div class="form-check mb-3">
<input class="form-check-input" type="checkbox" name="reset_password" value="1">
<label class="form-check-label">Reset password</label>
</div>
<button type="submit" name="update" class="btn btn-primary w-100">Update</button>
</form>
</div>
</div>

<!-- RESET -->
<div class="modal fade" id="pass<?= $s['id'] ?>">
<div class="modal-dialog modal-sm">
<form method="post" class="modal-content p-3 text-center">
<input type="hidden" name="id" value="<?= $s['id'] ?>">
<p>Reset password ke tanggal lahir?</p>
<button type="submit" name="reset_password_only" class="btn btn-warning w-100">Reset</button>
</form>
</div>
</div>

<!-- HAPUS -->
<div class="modal fade" id="hapus<?= $s['id'] ?>">
<div class="modal-dialog modal-sm">
<form method="post" class="modal-content p-3 text-center">
<input type="hidden" name="hapus_id" value="<?= $s['id'] ?>">
<p>Hapus <b><?= $s['nama'] ?></b>?</p>
<button type="submit" name="hapus" class="btn btn-danger w-100">Hapus</button>
</form>
</div>
</div>

<?php endwhile; ?>

<!-- TAMBAH -->
<div class="modal fade" id="tambah">
<div class="modal-dialog">
<form method="post" class="modal-content p-3">
<h5>Tambah Siswa</h5>
<input name="nisn" class="form-control mb-2" placeholder="NISN" required>
<input name="nama" class="form-control mb-2" placeholder="Nama" required>
<select name="jk" class="form-select mb-2">
<option value="L">Laki-laki</option>
<option value="P">Perempuan</option>
</select>
<input name="tempat_lahir" class="form-control mb-2" placeholder="Tempat Lahir" required>
<input type="date" name="tanggal_lahir" class="form-control mb-2" required>
<select name="kelas" class="form-select mb-2" required>
<option value="">-- Pilih Kelas --</option>
<?php foreach($kelasArr as $k): ?>
<option value="<?= $k['nama_kelas'] ?>"><?= $k['nama_kelas'] ?></option>
<?php endforeach; ?>
</select>
<select name="status" class="form-select mb-3">
<option value="Aktif">Aktif</option>
<option value="Nonaktif">Nonaktif</option>
</select>
<button type="submit" name="simpan" class="btn btn-success w-100">Simpan</button>
</form>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dibuat Oleh : <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
