<?php
require __DIR__ . '/../config/database.php';

/* ================= SESSION & ADMIN ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    $_SESSION['user']['role'] !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL SEKOLAH ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach ($tables as $t) {
    $c = mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if ($c && mysqli_num_rows($c)) {
        $q = mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if ($q && mysqli_num_rows($q)) {
            $s = mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah'] ?? $nama_sekolah;
            $logo          = $s['logo'] ?? $logo;
        }
        break;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= SIMPAN PAKET ================= */
if (isset($_POST['simpan'])) {

    $nama  = mysqli_real_escape_string($conn,$_POST['nama']);
    $jenis = mysqli_real_escape_string($conn,$_POST['jenis']);
    $tahun = mysqli_real_escape_string($conn,$_POST['tahun']);

    mysqli_query($conn,"
        INSERT INTO paket_ujian (nama_paket,jenis,tahun,status)
        VALUES ('$nama','$jenis','$tahun','Nonaktif')
    ");

    header("Location: paket.php");
    exit;
}

/* ================= AKTIFKAN ================= */
if (isset($_GET['aktif'])) {
    $id = (int)$_GET['aktif'];

    mysqli_begin_transaction($conn);
    mysqli_query($conn,"UPDATE paket_ujian SET status='Nonaktif'");
    mysqli_query($conn,"UPDATE paket_ujian SET status='Aktif' WHERE id='$id'");
    mysqli_commit($conn);

    header("Location: paket.php");
    exit;
}

/* ================= NONAKTIFKAN ================= */
if (isset($_GET['nonaktif'])) {
    $id = (int)$_GET['nonaktif'];

    mysqli_query($conn,"
        UPDATE paket_ujian SET status='Nonaktif'
        WHERE id='$id'
    ");

    header("Location: paket.php");
    exit;
}

/* ================= UPDATE PAKET ================= */
if (isset($_POST['update'])) {

    $id = (int)$_POST['id'];

    // 🔒 CEK STATUS (INI YANG PENTING)
    $cek = mysqli_fetch_assoc(mysqli_query($conn,"
        SELECT status FROM paket_ujian WHERE id='$id' LIMIT 1
    "));

    // Jika paket aktif → STOP
    if (!$cek || $cek['status'] === 'Aktif') {
        header("Location: paket.php");
        exit;
    }

    // lanjut update kalau NONAKTIF
    $nama  = mysqli_real_escape_string($conn, $_POST['nama']);
    $jenis = mysqli_real_escape_string($conn, $_POST['jenis']);
    $tahun = mysqli_real_escape_string($conn, $_POST['tahun']);

    mysqli_query($conn, "
        UPDATE paket_ujian SET
            nama_paket = '$nama',
            jenis      = '$jenis',
            tahun      = '$tahun'
        WHERE id = '$id'
    ");

    header("Location: paket.php");
    exit;
}


/* ================= DATA ================= */
$data = mysqli_query($conn,"
    SELECT p.*,
    (
        SELECT COUNT(*)
        FROM ujian u
        WHERE u.id_paket = p.id
    ) total_ujian
    FROM paket_ujian p
    ORDER BY p.id DESC
");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($nama_aplikasi) ?> | Paket Ujian</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.submenu a{padding-left:42px;font-size:14px}
.content{margin-left:260px;padding:24px}
/* FOOTER */
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#000;
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <b><?= htmlspecialchars($nama_aplikasi) ?></b><br>
      <small><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>

  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
    
  </div>
  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

<!-- CONTENT -->
<div class="content">

<h4 class="fw-bold mb-3">📦 Paket Ujian</h4>

<form method="post" class="row g-2 mb-3">
  <input name="nama" class="form-control col" placeholder="Nama Paket" required>
  <select name="jenis" class="form-select col">
    <option>UTS</option>
    <option>UAS</option>
    <option>TRYOUT</option>
    <option>ASESMEN</option>
  </select>
  <input name="tahun" class="form-control col" placeholder="2025/2026" required>
  <button name="simpan" class="btn btn-primary col">Simpan</button>
</form>

<table class="table table-bordered bg-white align-middle">
<thead class="table-dark">
<tr>
  <th>Paket</th>
  <th>Jenis</th>
  <th>Tahun</th>
  <th>Ujian</th>
  <th>Status</th>
  <th width="180">Aksi</th>
</tr>
</thead>
<tbody>
<?php while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td><?= htmlspecialchars($r['nama_paket']) ?></td>
<td><?= htmlspecialchars($r['jenis']) ?></td>
<td><?= htmlspecialchars($r['tahun']) ?></td>
<td><span class="badge bg-info"><?= $r['total_ujian'] ?> ujian</span></td>
<td>
<span class="badge bg-<?= $r['status']=='Aktif'?'success':'secondary' ?>">
<?= $r['status'] ?>
</span>
</td>
<td class="text-center">

<!-- EDIT PAKET -->
<?php if($r['status'] != 'Aktif'): ?>
<button
  class="btn btn-sm btn-warning btn-edit"
  data-id="<?= $r['id'] ?>"
  data-nama="<?= htmlspecialchars($r['nama_paket']) ?>"
  data-jenis="<?= htmlspecialchars($r['jenis']) ?>"
  data-tahun="<?= htmlspecialchars($r['tahun']) ?>"
  title="Edit Paket"
>
  <i class="bi bi-pencil"></i>
</button>
<?php else: ?>
<button
  class="btn btn-sm btn-secondary"
  disabled
  title="Paket Aktif tidak bisa diedit"
>
  <i class="bi bi-lock"></i>
</button>
<?php endif ?>


<!-- KELOLA UJIAN -->
<a href="ujian.php?id_paket=<?= $r['id'] ?>" 
   class="btn btn-sm btn-primary" 
   title="Kelola Ujian">
  <i class="bi bi-journal-text"></i>
</a>

<?php if($r['status']=='Aktif'): ?>
<a href="?nonaktif=<?= $r['id'] ?>" class="btn btn-sm btn-danger">
  <i class="bi bi-x-circle"></i>
</a>
<?php else: ?>
<a href="?aktif=<?= $r['id'] ?>" class="btn btn-sm btn-success">
  <i class="bi bi-check-circle"></i>
</a>
<?php endif ?>

</td>

</tr>
<?php endwhile ?>
</tbody>
</table>

</div>

<!-- MODAL EDIT PAKET -->
<div class="modal fade" id="modalEdit" tabindex="-1">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      
      <div class="modal-header">
        <h5 class="modal-title">✏️ Edit Paket Ujian</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <input type="hidden" name="id" id="edit_id">

        <div class="mb-2">
          <label>Nama Paket</label>
          <input type="text" name="nama" id="edit_nama" class="form-control" required>
        </div>

        <div class="mb-2">
          <label>Jenis</label>
          <select name="jenis" id="edit_jenis" class="form-select">
            <option>UTS</option>
            <option>UAS</option>
            <option>TRYOUT</option>
            <option>ASESMEN</option>
          </select>
        </div>

        <div class="mb-2">
          <label>Tahun</label>
          <input type="text" name="tahun" id="edit_tahun" class="form-control" required>
        </div>
      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <button type="submit" name="update" class="btn btn-primary">
          <i class="bi bi-save"></i> Simpan
        </button>
      </div>

    </form>
  </div>
</div>
<script>
document.querySelectorAll('.btn-edit').forEach(btn => {
  btn.addEventListener('click', function () {
    document.getElementById('edit_id').value    = this.dataset.id;
    document.getElementById('edit_nama').value  = this.dataset.nama;
    document.getElementById('edit_jenis').value = this.dataset.jenis;
    document.getElementById('edit_tahun').value = this.dataset.tahun;

    new bootstrap.Modal(document.getElementById('modalEdit')).show();
  });
});
</script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dibuat Oleh : <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
