<?php
require '../config/database.php';
session_start();

if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
  exit('Akses ditolak');
}

/* ===== FILTER ===== */
$kelas = $_GET['kelas'] ?? '';
$siswa = $_GET['siswa'] ?? '';
$mapel = $_GET['mapel'] ?? '';

$where = [];
if ($kelas && $kelas !== 'Semua')
  $where[] = "s.kelas='".mysqli_real_escape_string($conn,$kelas)."'";
if ($siswa && $siswa !== 'Semua')
  $where[] = "s.id=".(int)$siswa;
if ($mapel && $mapel !== 'Semua')
  $where[] = "m.id=".(int)$mapel;

$whereSQL = $where ? "WHERE ".implode(" AND ",$where) : "";

/* ===== QUERY ===== */
$sql = "
SELECT
  s.nama,
  s.nisn,
  s.kelas,
  m.nama_mapel,

  so.soal,
  so.tipe,
  so.kunci,
  so.a, so.b, so.c, so.d, so.e,

  j.jawaban_pg,
  j.jawaban_essay,
  ao.huruf_asli

FROM jawaban j
JOIN soal so ON so.id = j.id_soal
JOIN ujian u ON u.id = so.id_ujian
JOIN mapel m ON m.id = u.id_mapel
JOIN siswa s ON s.id = j.id_siswa
LEFT JOIN acak_opsi ao
  ON ao.id_soal = so.id
 AND ao.id_siswa = j.id_siswa
 AND ao.huruf_tampil = j.jawaban_pg
$whereSQL
ORDER BY so.id
";

$q = mysqli_query($conn,$sql);
$rAwal = mysqli_fetch_assoc($q);
mysqli_data_seek($q,0);

/* ===== HEADER EXCEL ===== */
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Jawaban_Siswa.xls");
header("Pragma: no-cache");
header("Expires: 0");
?>

<table border="0">
<tr><td colspan="5"><b>Nama</b> : <?= $rAwal['nama'] ?></td></tr>
<tr><td colspan="5"><b>NISN</b> : <?= $rAwal['nisn'] ?></td></tr>
<tr><td colspan="5"><b>Kelas</b> : <?= $rAwal['kelas'] ?></td></tr>
<tr><td colspan="5">&nbsp;</td></tr>
<tr><td colspan="5"><b>Mata Pelajaran : <?= $rAwal['nama_mapel'] ?></b></td></tr>
<tr><td colspan="5">&nbsp;</td></tr>
</table>

<table border="1" cellpadding="5">
<tr style="background:#eee;font-weight:bold;text-align:center">
  <th>No</th>
  <th>Soal</th>
  <th>Kunci</th>
  <th>Jawaban</th>
  <th>Status</th>
</tr>

<?php
$no=1;
while($r=mysqli_fetch_assoc($q)):

$opsi = [
  'A'=>$r['a'],
  'B'=>$r['b'],
  'C'=>$r['c'],
  'D'=>$r['d'],
  'E'=>$r['e']
];

if ($r['tipe'] === 'pg') {

  $huruf_jawaban = $r['huruf_asli'] ?: $r['jawaban_pg'];

  $jawaban = $opsi[$huruf_jawaban] ?? '-';
  $kunci   = $opsi[$r['kunci']] ?? '-';

  $status = ($huruf_jawaban === $r['kunci']) ? 'BENAR' : 'SALAH';

} else {

  $jawaban = $r['jawaban_essay'] ?: '-';
  $kunci   = '-';
  $status  = 'ESSAY';

}
?>

<tr>
  <td align="center"><?= $no++ ?></td>
  <td><?= strip_tags($r['soal']) ?></td>
  <td><?= $kunci ?></td>
  <td><?= $jawaban ?></td>
  <td align="center"><?= $status ?></td>
</tr>

<?php endwhile ?>
</table>

<br><br>
<table border="0" width="100%">
<tr>
  <td align="right">
    Pengawas<br><br><br>
    ( ____________________ )
  </td>
</tr>
</table>
