<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

/* ================= KONEKSI DB PKBM ================= */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2){
    die("Koneksi database PKBM gagal: ".mysqli_connect_error());
}

/* ================= PROTEKSI ADMIN ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$kelas = $_GET['kelas'] ?? '';

/* ================= PROFIL SEKOLAH ================= */
$nama_sekolah = 'SEKOLAH';
$alamat       = '';
$logo         = 'default.png';

$q = mysqli_query($conn,"SHOW TABLES LIKE 'sekolah'");
if ($q && mysqli_num_rows($q) > 0) {
    $qs = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
    if($qs && mysqli_num_rows($qs)>0){
        $d = mysqli_fetch_assoc($qs);
        $nama_sekolah = $d['nama_sekolah'] ?? $nama_sekolah;
        $alamat       = $d['alamat'] ?? '';
        $logo         = $d['logo'] ?? $logo;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* ================= DATA SISWA ================= */
$sql = "
SELECT 
    s.id,
    s.nisn,
    s.nama,
    CONCAT(k.nama_kelas,'-',CHAR(64+k.paket_id)) AS kelas
FROM siswa s
JOIN kelas k ON k.id = s.kelas_id
";

if ($kelas !== '') $sql .= " WHERE k.id=?";
$sql .= " ORDER BY s.nama";

$stmt = mysqli_prepare($conn2,$sql);
if (!$stmt) die("Prepare gagal: ".mysqli_error($conn2));

if ($kelas !== '') mysqli_stmt_bind_param($stmt,"i",$kelas);

mysqli_stmt_execute($stmt);
$siswa = mysqli_stmt_get_result($stmt);


if(!$siswa) die("Query siswa gagal");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Nilai Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{font-size:14px;color:#000}

.table-data th,
.table-data td{
  border:1px solid #000;
  padding:4px;
}

.table-data th{
  background:#e9ecef;
  text-align:center;
}

.kop td,.kop th{
  border:0 !important;
  padding:2px;
}

.garis-dinas{
  border-top:3px solid #000;
  border-bottom:1px solid #000;
  height:6px;
  margin:8px 0 16px
}

.page-break{page-break-after:always}

@media print{
  body{margin:0}
}

</style>

<script>
window.onload = function(){
  window.print();
}
</script>
</head>
<body>

<?php if(mysqli_num_rows($siswa)==0): ?>
<div class="text-center mt-5">
  <h5>Data siswa tidak ditemukan</h5>
</div>
<?php endif; ?>

<?php while($s=mysqli_fetch_assoc($siswa)): ?>

<!-- KOP SEKOLAH -->
<table width="100%" class="kop">
<tr>
  <td width="90" align="center" valign="middle">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" width="80">
  </td>
  <td valign="middle">
    <div style="font-size:18px;font-weight:bold;text-transform:uppercase">
      <?= htmlspecialchars($nama_sekolah) ?>
    </div>
    <div style="font-size:12px">
      <?= htmlspecialchars($alamat) ?>
    </div>
  </td>
</tr>
</table>


<div class="garis-dinas"></div>

<!-- IDENTITAS SISWA -->
<table class="mb-3">
<tr><td width="80"><b>Nama</b></td><td>: <?= htmlspecialchars($s['nama']) ?></td></tr>
<tr><td><b>NISN</b></td><td>: <?= htmlspecialchars($s['nisn']) ?></td></tr>
<tr><td><b>Kelas</b></td><td>: <?= htmlspecialchars($s['kelas']) ?></td></tr>
</table>

<!-- NILAI -->
<table class="table table-bordered">
<thead>
<tr>
  <th width="50">No</th>
  <th>Mata Pelajaran</th>
  <th width="120">Nilai</th>
</tr>
</thead>
<tbody>
<?php
$qNilai = mysqli_query($conn,"
SELECT 
    m.nama_mapel, 
    h.nilai
FROM hasil h
JOIN ujian u ON u.id = h.id_ujian
LEFT JOIN pkbm_taruna_qurani.mapel m 
       ON m.id = u.id_mapel
WHERE h.id_siswa=".(int)$s['id']."
ORDER BY m.nama_mapel
");


if($qNilai && mysqli_num_rows($qNilai)>0):
$no=1;
while($n=mysqli_fetch_assoc($qNilai)):
?>
<tr>
  <td class="text-center"><?= $no++ ?></td>
  <td><?= htmlspecialchars($n['nama_mapel'] ?? '-') ?></td>
  <td class="text-center fw-bold"><?= (int)$n['nilai'] ?></td>
</tr>
<?php endwhile; else: ?>
<tr>
  <td colspan="3" class="text-center">Belum ada nilai</td>
</tr>
<?php endif ?>
</tbody>
</table>

<!-- TTD -->
<div class="text-end mt-5">
Pengawas<br><br><br>
<b>( ..................................... )</b>
</div>

<div class="page-break"></div>
<?php endwhile ?>

</body>
</html>
