<?php
require __DIR__ . '/../config/database.php';
session_start();

header('Content-Type: application/json');

/* ================= PROTEKSI ADMIN ================= */
if(empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '')!=='admin'){
    http_response_code(403);
    echo json_encode(['error'=>'Akses ditolak']);
    exit;
}

/* ================= PARAM ================= */
$id_ujian  = (int)($_GET['ujian'] ?? 0);
$lastCheck = (int)($_GET['last'] ?? 0);

if($id_ujian <= 0){
    echo json_encode(['ada'=>false,'last_time'=>$lastCheck]);
    exit;
}

/* ================= QUERY ================= */
$sql = "
    SELECT 
        p.id_siswa,
        p.jenis_pelanggaran AS jenis,
        s.nama,
        wl.foto,
        UNIX_TIMESTAMP(p.waktu)  AS pel_time,
        UNIX_TIMESTAMP(wl.waktu) AS foto_time
    FROM smart_cbt.pelanggaran_ujian p
    JOIN pkbm_taruna_qurani.siswa s 
        ON s.id = p.id_siswa
    LEFT JOIN smart_cbt.webcam_log wl
        ON wl.id_siswa = p.id_siswa
       AND wl.id_ujian = p.id_ujian
       AND UNIX_TIMESTAMP(wl.waktu) > $lastCheck
    WHERE p.id_ujian = $id_ujian
      AND UNIX_TIMESTAMP(p.waktu) > $lastCheck
    ORDER BY p.waktu ASC, wl.waktu ASC
";

$q = mysqli_query($conn,$sql);
if(!$q){
    echo json_encode(['error'=>mysqli_error($conn)]);
    exit;
}

/* ================= PROSES ================= */
$data = [];
$lastTime = $lastCheck;

while($r = mysqli_fetch_assoc($q)){
    $id = (int)$r['id_siswa'];

    if(!isset($data[$id])){
        $data[$id] = [
            'id_siswa' => $id,
            'nama'     => $r['nama'],
            'jenis'    => $r['jenis'],
            'fotoBaru' => []
        ];
    }

    if(!empty($r['foto'])){
        $data[$id]['fotoBaru'][] =
            "../uploads/webcam/ujian_$id_ujian/".$r['foto'];
    }

    $lastTime = max($lastTime,(int)$r['pel_time'],(int)$r['foto_time']);
}

/* ================= OUTPUT ================= */
echo json_encode([
    'ada'        => !empty($data),
    'pelanggaran'=> array_values($data),
    'last_time'  => $lastTime
]);
exit;
