<?php
session_start();
require "koneksi.php";
date_default_timezone_set('Asia/Jakarta');
header('Content-Type: application/json');

/* ================= CEK LOGIN ================= */
if (empty($_SESSION['login_tutor']) || empty($_SESSION['tutor_id'])) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Akses ditolak'
    ]);
    exit;
}

$tutor_id = (int) $_SESSION['tutor_id'];
$tanggal  = date('Y-m-d');

/* ================= CEK PRESENSI ================= */
$stmt = mysqli_prepare($conn, "
    SELECT waktu 
    FROM presensi_guru
    WHERE tutor_id = ? AND tanggal = ?
    LIMIT 1
");

mysqli_stmt_bind_param($stmt, "is", $tutor_id, $tanggal);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

/* ================= RESPONSE ================= */
if ($result && mysqli_num_rows($result) > 0) {
    $row = mysqli_fetch_assoc($result);

    echo json_encode([
        'status' => 'sudah',
        'waktu'  => date('H:i:s', strtotime($row['waktu']))
    ]);
} else {
    echo json_encode([
        'status' => 'belum'
    ]);
}
