<?php
session_start();
require_once __DIR__ . '/edu_digital/config/database.php';

$fotoFolder  = '/pkbm-test/edu_digital/uploads/guru-manajemen/';

/* ================= PEMBINA (VIP) ================= */
$pembina = mysqli_query($conn,"
SELECT * FROM guru_manajemen
WHERE status = 'Pembina'
ORDER BY id DESC
LIMIT 1
");

/* ================= MANAJEMEN / PENGURUS ================= */
$manajemen = mysqli_query($conn,"
SELECT * FROM guru_manajemen
WHERE status = 'Manajemen'
ORDER BY jabatan, nama
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Struktur Yayasan</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>
body{
  margin:0;
  font-family:'Segoe UI',sans-serif;
  background:linear-gradient(135deg,#020617,#0f172a);
}
.phone{
  max-width:430px;
  margin:auto;
  min-height:100vh;
  padding-bottom:85px;
}
.header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:14px 12px;
  background:rgba(255,255,255,0.05);
  backdrop-filter:blur(12px);
}
.header-title{
  flex:1;
  text-align:center;
  color:#fff;
  font-weight:600;
}
.logo{
  width:40px;
  height:40px;
  border-radius:50%;
  object-fit:cover;
}
.vip-card{
  margin:16px;
  border-radius:22px;
  overflow:hidden;
  background:linear-gradient(135deg,#1e293b,#020617);
  box-shadow:0 15px 40px rgba(0,0,0,.6);
}
.vip-card img{
  width:100%;
  aspect-ratio:3/4;
  object-fit:cover;
  object-position:top;
}
.vip-info{
  padding:16px;
  text-align:center;
}
.vip-badge{
  background:linear-gradient(135deg,#facc15,#fbbf24);
  color:#000;
  padding:6px 16px;
  border-radius:20px;
  font-size:12px;
  display:inline-block;
  margin-bottom:10px;
}
.vip-name{
  font-size:20px;
  font-weight:700;
  color:#fff;
}
.vip-jabatan{
  color:#93c5fd;
}
.section-title{
  padding:10px 16px;
  color:#fff;
  font-weight:600;
}
.grid{
  display:grid;
  grid-template-columns:repeat(2,1fr);
  gap:14px;
  padding:14px;
}
.card{
  background:rgba(255,255,255,.06);
  border-radius:18px;
  overflow:hidden;
}
.card img{
  width:100%;
  aspect-ratio:3/4;
  object-fit:cover;
}
.info{
  padding:10px;
  text-align:center;
}
.nama{
  font-weight:600;
  color:#fff;
}
.jabatan{
  font-size:12px;
  color:#60a5fa;
}
/* ===== BOTTOM NAV RESPONSIVE & MODERN ===== */
.bottom{
  position:fixed;
  bottom:0;
  left:50%;
  transform:translateX(-50%);
  width:100%;
  max-width:430px;
  height:70px;
  background:rgba(2,6,23,0.95);
  backdrop-filter:blur(10px);
  display:flex;
  justify-content:space-around;
  align-items:center;
  padding:0 6px;
  box-shadow:0 -8px 25px rgba(0,0,0,.6);
  border-top-left-radius:20px;
  border-top-right-radius:20px;
  z-index:999;
}

.bottom a{
  flex:1;
  color:#cbd5e1;
  font-size:11px;
  text-decoration:none;
  text-align:center;
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:center;
  transition:.3s ease;
}

.bottom a i{
  font-size:20px;
  margin-bottom:4px;
  transition:.3s ease;
}

/* Hover Effect */
.bottom a:hover{
  color:#60a5fa;
  transform:translateY(-3px);
}

.bottom a:hover i{
  transform:scale(1.15);
}

/* Active State */
.bottom a.active{
  color:#38bdf8;
  font-weight:600;
}

.bottom a.active i{
  transform:scale(1.2);
}
</style>
</head>

<body>
<div class="phone">

<!-- HEADER -->
<div class="header">
  <img src="assets/img/logo_kiri.PNG" class="logo">
  <div class="header-title">DHARMANANDA AGUNG ACADEMY</div>
  <img src="assets/img/logo_kanan.PNG" class="logo">
</div>

<!-- ================= PEMBINA ================= -->
<?php if($pembina && mysqli_num_rows($pembina)>0):
$p = mysqli_fetch_assoc($pembina);
$foto = !empty($p['foto']) ? htmlspecialchars($p['foto']) : 'default.png';
?>
<div class="vip-card">
  <img src="<?= $fotoFolder.$foto ?>">
  <div class="vip-info">
    <div class="vip-badge">Pembina</div>
    <div class="vip-name"><?= htmlspecialchars($p['nama']) ?></div>
    <div class="vip-jabatan"><?= htmlspecialchars($p['jabatan']) ?></div>
  </div>
</div>
<?php endif; ?>

<!-- ================= MANAJEMEN ================= -->
<?php if($manajemen && mysqli_num_rows($manajemen)>0): ?>
<div class="section-title">Manajemen / Pengurus</div>
<div class="grid">
<?php while($m=mysqli_fetch_assoc($manajemen)):
$foto = !empty($m['foto']) ? htmlspecialchars($m['foto']) : 'default.png';
?>
<div class="card">
  <img src="<?= $fotoFolder.$foto ?>">
  <div class="info">
    <div class="nama"><?= htmlspecialchars($m['nama']) ?></div>
    <div class="jabatan"><?= htmlspecialchars($m['jabatan']) ?></div>
  </div>
</div>
<?php endwhile; ?>
</div>
<?php endif; ?>

</div>

<!-- NAV -->
<div class="bottom">
  <a href="/pkbm-test/index.html"><i class="bi bi-house"></i><br>Home</a>
  <a href="#"><i class="bi bi-calendar"></i><br>Jadwal</a>
  <a href="#"><i class="bi bi-chat"></i><br>Chat</a>
  <a href="profil_guru.php"><i class="bi bi-person"></i><br>Profil</a>
</div>

</body>
</html>