<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    die('Akses ditolak');
}

$aksi = $_POST['aksi'] ?? '';

/* =====================================================
   TAMBAH SOAL — FINAL STABIL SEKOLAH DIGITAL PRO 👑
===================================================== */
if ($aksi === 'tambah') {

    $materi_id  = (int)($_POST['materi_id'] ?? 0);
    $pertanyaan = trim($_POST['pertanyaan'] ?? '');
    $tipe       = $_POST['tipe'] ?? '';

    if (!$materi_id || !$pertanyaan || !$tipe) {
        die('Data soal tidak lengkap');
    }

    /* ================= SIMPAN SOAL ================= */
    $stmt = $conn->prepare("
        INSERT INTO materi_soal (materi_id, pertanyaan, tipe)
        VALUES (?, ?, ?)
    ");
    $stmt->bind_param("iss", $materi_id, $pertanyaan, $tipe);
    $stmt->execute();
    $soal_id = $stmt->insert_id;

    /* =================================================
       PILIHAN GANDA (PG)
    ================================================= */
    if ($tipe === 'pg') {

        $a = trim($_POST['a'] ?? '');
        $b = trim($_POST['b'] ?? '');
        $c = trim($_POST['c'] ?? '');
        $d = trim($_POST['d'] ?? '');

        if ($a=='' || $b=='' || $c=='' || $d=='') {
            die('Opsi A, B, C, dan D wajib diisi');
        }

        /* ===== AUTO DETEKSI JAWABAN RADIO ===== */
        $jawaban = null;

        foreach ($_POST as $val) {
            if (in_array($val, ['A','B','C','D','0','1','2','3'])) {
                $jawaban = $val;
                break;
            }
        }

        if ($jawaban === null) {
            die('Jawaban PG belum dipilih');
        }

        // Normalisasi
        if (is_numeric($jawaban)) {
            $map = ['A','B','C','D'];
            $jawaban = $map[(int)$jawaban] ?? '';
        }

        if (!in_array($jawaban, ['A','B','C','D'])) {
            die('Format jawaban PG tidak valid');
        }

        $opsi = [
            'A' => $a,
            'B' => $b,
            'C' => $c,
            'D' => $d
        ];

        foreach ($opsi as $huruf => $teks) {

            $benar = ($huruf === $jawaban) ? 1 : 0;

            $stmt = $conn->prepare("
                INSERT INTO materi_soal_opsi (soal_id, opsi, benar)
                VALUES (?, ?, ?)
            ");
            $stmt->bind_param("isi", $soal_id, $teks, $benar);
            $stmt->execute();
        }
    }

    /* =================================================
   BENAR / SALAH (BS) — FINAL FIX 100% 🔥
================================================= */
if ($tipe === 'bs') {

    // Ambil dari select
    $jawaban = $_POST['jawaban_bs'] ?? '';

    if ($jawaban !== 'benar' && $jawaban !== 'salah') {
        die('Jawaban Benar / Salah belum dipilih');
    }

    foreach (['benar', 'salah'] as $opsi) {

        $benar = ($jawaban === $opsi) ? 1 : 0;
        $label = ucfirst($opsi); // Benar / Salah

        $stmt = $conn->prepare("
            INSERT INTO materi_soal_opsi (soal_id, opsi, benar)
            VALUES (?, ?, ?)
        ");
        $stmt->bind_param("isi", $soal_id, $label, $benar);
        $stmt->execute();
    }
}


    /* =================================================
       ESSAY / ISIAN — BISA ADA JAWABAN ATAU MANUAL 👑
    ================================================= */
    if ($tipe === 'essay' || $tipe === 'isian') {

        $jawaban = trim($_POST['jawaban'] ?? '');

        // Kalau tutor isi jawaban → simpan sebagai kunci
        if ($jawaban !== '') {

            $stmt = $conn->prepare("
                INSERT INTO materi_soal_opsi (soal_id, opsi, benar)
                VALUES (?, ?, 1)
            ");
            $stmt->bind_param("is", $soal_id, $jawaban);
            $stmt->execute();
        }
        // Kalau kosong → tidak simpan apa-apa → dinilai manual
    }

    header("Location: " . $_SERVER['HTTP_REFERER']);
    exit;
}

die('Aksi tidak dikenal');
