<?php 
session_start();
require '../config/database.php';
require '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    die('Akses ditolak');
}

/* ================= PARAMETER ================= */
$siswa_id  = (int)($_GET['s'] ?? 0);
$materi_id = (int)($_GET['m'] ?? 0);

if (!$siswa_id || !$materi_id) {
    die('Parameter tidak valid');
}

/* ================= HEADER DATA ================= */
$qHeader = mysqli_query($conn,"
 SELECT 
   s.nama AS nama_siswa,
   CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS kelas,
   mp.nama_mapel,
   m.judul AS materi,
   COUNT(mjs.id) AS total_soal,
   SUM(mjs.benar) AS jumlah_benar,
   (COUNT(mjs.id) - SUM(mjs.benar)) AS jumlah_salah,
   ROUND((SUM(mjs.benar)/COUNT(mjs.id))*100,0) AS nilai,
   MIN(mjs.dijawab_pada) AS mulai,
   MAX(mjs.dijawab_pada) AS selesai
 FROM materi_jawaban_siswa mjs
 JOIN siswa s ON s.id = mjs.siswa_id
 JOIN kelas k ON k.id = s.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN materi m ON m.id = mjs.materi_id
 JOIN mapel mp ON mp.id = m.mapel_id
 WHERE mjs.siswa_id = $siswa_id
   AND mjs.materi_id = $materi_id
");

$data = mysqli_fetch_assoc($qHeader);
if(!$data){
    die('Data tidak ditemukan');
}

/* ================= DETAIL SOAL ================= */
$qDetail = mysqli_query($conn,"
 SELECT 
   so.pertanyaan,
   mjs.jawaban,
   mjs.benar
 FROM materi_jawaban_siswa mjs
 JOIN materi_soal so ON so.id = mjs.soal_id
 WHERE mjs.siswa_id = $siswa_id
   AND mjs.materi_id = $materi_id
 ORDER BY so.urutan ASC
");

/* ================= HTML ================= */
$html = '
<style>
body{font-family:DejaVu Sans;font-size:11px}
h2{margin:0;text-align:center;font-size:16px}
.sub{text-align:center;font-size:12px;margin-bottom:6px}
hr{margin:6px 0}

.header-wrap{position:relative;margin-bottom:12px}

.info{
 width:65%;
 float:left;
}
.info table{width:100%}
.info td{padding:3px 0}


.nilai-box-wrap{
 width:30%;
 float:right;
 text-align:center;
 border:2px solid #000;
 padding:10px;
}
.nilai-title{
 font-size:11px;
 font-weight:bold;
 letter-spacing:1px;
}
.nilai-score{
 font-size:34px;
 font-weight:bold;
 margin-top:6px;
}

/* HILANGKAN GARIS TABEL INFO HEADER SAJA */
.info table td,
.info table th{
  border:none !important;
}


.clear{clear:both}

table{width:100%;border-collapse:collapse;margin-top:10px}
th,td{border:1px solid #000;padding:6px}
th{background:#eee;text-align:center}
.center{text-align:center}
.left{text-align:left}

.benar{color:green;font-weight:bold}
.salah{color:red;font-weight:bold}

.ttd{
 margin-top:40px;
 width:220px;
 float:right;
 text-align:center;
}
</style>

<h2>PKBM TARUNA QURANI</h2>
<div class="sub">LAPORAN NILAI SISWA</div>
<hr>

<div class="header-wrap">

 <div class="info">
  <table>
   <tr>
    <td width="90">Nama Siswa</td><td width="10">:</td>
    <td>'.$data['nama_siswa'].'</td>
   </tr>
   <tr>
    <td>Kelas</td><td>:</td>
    <td>'.$data['kelas'].'</td>
   </tr>
   <tr>
    <td>Mapel</td><td>:</td>
    <td>'.$data['nama_mapel'].'</td>
   </tr>
  </table>
 </div>

 <div class="nilai-box-wrap">
  <div class="nilai-title">NILAI</div>
  <div class="nilai-score">'.$data['nilai'].'</div>
 </div>

</div>

<div class="clear"></div>

<table>
<tr>
 <th width="35%">Materi</th>
 <th width="15%">Total Soal</th>
 <th width="10%">Benar</th>
 <th width="10%">Salah</th>
 <th width="30%">Waktu</th>
</tr>
<tr>
 <td class="left">'.$data['materi'].'</td>
 <td class="center">'.$data['total_soal'].'</td>
 <td class="center">'.$data['jumlah_benar'].'</td>
 <td class="center">'.$data['jumlah_salah'].'</td>
 <td class="center">'.
   date("d-m-Y H:i",strtotime($data['mulai'])).
   ' - '.
   date("H:i",strtotime($data['selesai'])).
 '</td>
</tr>
</table>

<table>
<tr>
 <th width="5%">No</th>
 <th>Pertanyaan</th>
 <th width="15%">Jawaban</th>
 <th width="12%">Status</th>
</tr>
';

$no=1;
while($d=mysqli_fetch_assoc($qDetail)){
 $html .= '
 <tr>
  <td class="center">'.$no++.'</td>
  <td class="left">'.nl2br(htmlspecialchars($d['pertanyaan'])).'</td>
  <td class="center">'.$d['jawaban'].'</td>
  <td class="center">'.($d['benar']
     ? '<span class="benar">BENAR</span>'
     : '<span class="salah">SALAH</span>').'</td>
 </tr>';
}

$html .= '
</table>

<div class="ttd">
Pengawas<br><br><br>
____________________
</div>
';

/* ================= GENERATE PDF ================= */
$options = new Options();
$options->set('defaultFont','DejaVu Sans');
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','portrait');
$dompdf->render();
$dompdf->stream("Nilai_Siswa.pdf", ["Attachment"=>false]);
