<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

$tutor_id = $_SESSION['user']['id'];

/* ================= FILTER ================= */
$kelas_id = $_GET['kelas_id'] ?? '';
$mapel_id = $_GET['mapel_id'] ?? '';
$siswa_id = $_GET['siswa_id'] ?? '';

$where = "WHERE km.tutor_id = '$tutor_id'";

if ($kelas_id) {
    $where .= " AND k.id = '$kelas_id'";
}
if ($mapel_id) {
    $where .= " AND mp.id = '$mapel_id'";
}
if ($siswa_id) {
    $where .= " AND s.id = '$siswa_id'";
}

/* ================= DATA FILTER ================= */
$qKelas = mysqli_query($conn,"
 SELECT DISTINCT 
    k.id,
    CONCAT(k.nama_kelas,'-',p.nama) AS nama_kelas
 FROM kelas k
 JOIN paket p ON p.id = k.paket_id
 JOIN kelas_mengajar km ON km.kelas_id = k.id
 WHERE km.tutor_id = '$tutor_id'
 ORDER BY k.nama_kelas, p.nama
");

$qMapel = mysqli_query($conn,"
 SELECT DISTINCT mp.id, mp.nama_mapel
 FROM mapel mp
 JOIN kelas_mengajar km ON km.mapel_id = mp.id
 WHERE km.tutor_id = '$tutor_id'
 ".($kelas_id ? " AND km.kelas_id = '$kelas_id'" : "")."
 ORDER BY mp.nama_mapel
");

$qSiswa = mysqli_query($conn,"
 SELECT DISTINCT s.id, s.nama
 FROM siswa s
 JOIN kelas k ON s.kelas_id = k.id
 JOIN kelas_mengajar km ON km.kelas_id = k.id
 WHERE km.tutor_id = '$tutor_id'
 ORDER BY s.nama
");

/* ================= DATA UTAMA ================= */
$q = mysqli_query($conn,"
 SELECT
  s.nama AS nama_siswa,
  CONCAT(k.nama_kelas,'-',p.nama) AS kelas_label,
  mp.nama_mapel,
  m.judul AS judul_materi,
  ms.pertanyaan,

  mjs.jawaban AS jawaban_siswa,
  mjs.dijawab_pada,

  kunci.opsi AS kunci_jawaban

 FROM materi_jawaban_siswa mjs

 JOIN siswa s ON s.id = mjs.siswa_id
 JOIN kelas k ON k.id = s.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN kelas_mengajar km ON km.kelas_id = k.id
 JOIN materi m ON m.id = mjs.materi_id
 JOIN mapel mp ON mp.id = m.mapel_id
 JOIN materi_soal ms ON ms.id = mjs.soal_id

 LEFT JOIN materi_soal_opsi kunci
   ON kunci.soal_id = ms.id
  AND kunci.benar = 1

 $where
 ORDER BY mjs.dijawab_pada DESC
");



if(!$q){
    die("Query Error: ".mysqli_error($conn));
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Absensi & Jawaban Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
html,body{height:100%}
body{
 background:#f4f6f9;
 font-size:14px;
 display:flex;
 flex-direction:column;
}
.main-wrapper{
 flex:1;
 padding:20px;
 padding-left:280px;
}
@media(max-width:991px){
 .main-wrapper{padding-left:15px}
}

.card{border-radius:16px}
.table td{vertical-align:top}
.table thead th{white-space:nowrap}

.badge-benar{background:#198754}
.badge-salah{background:#dc3545}

.filter-box label{
 font-size:12px;
 font-weight:600;
}

.footer{
 background:#fff;
 border-top:1px solid #ddd;
 padding:12px;
 font-size:12px;
 color:#666;
 text-align:center;
}
/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<div class="d-lg-none sticky-top bg-primary text-white px-3 py-2 d-flex align-items-center gap-2">
    <button class="btn btn-light btn-sm"
        data-bs-toggle="offcanvas"
        data-bs-target="#sidebarTutor">
        <i class="bi bi-list"></i>
    </button>
    <strong class="mb-0">Absensi & Jawaban</strong>
</div>

<?php include 'sidebar.php'; ?>

<div class="main-wrapper">

<div class="card shadow-sm mb-3">
 <div class="card-body">
  <form method="GET" class="row g-2 filter-box">

   <div class="col-12 col-md-3">
    <label>Siswa</label>
    <select name="siswa_id" class="form-select form-select-sm">
     <option value="">Semua</option>
     <?php while($s=mysqli_fetch_assoc($qSiswa)){ ?>
      <option value="<?= $s['id'] ?>" <?= $siswa_id==$s['id']?'selected':'' ?>>
        <?= $s['nama'] ?>
      </option>
     <?php } ?>
    </select>
   </div> 

  <div class="col-12 col-md-3">
  <label>Kelas</label>
    <select name="kelas_id" class="form-select form-select-sm">
     <option value="">Semua</option>
     <?php while($k=mysqli_fetch_assoc($qKelas)){ ?>
      <option value="<?= $k['id'] ?>" <?= $kelas_id==$k['id']?'selected':'' ?>>
        <?= $k['nama_kelas'] ?>
      </option>
     <?php } ?>

  </select>
</div>


   <div class="col-12 col-md-3">
    <label>Mapel</label>
    <select name="mapel_id" class="form-select form-select-sm">
     <option value="">Semua</option>
     <?php while($m=mysqli_fetch_assoc($qMapel)){ ?>
      <option value="<?= $m['id'] ?>" <?= $mapel_id==$m['id']?'selected':'' ?>>
        <?= $m['nama_mapel'] ?>
      </option>
     <?php } ?>
    </select>
   </div>

   <div class="col-12 col-md-3 d-flex align-items-end">
    <button class="btn btn-primary btn-sm w-100">
     <i class="bi bi-funnel"></i> Terapkan Filter
    </button>
   </div>

  </form>
 </div>
</div>

<div class="card shadow-sm">
 <div class="card-header bg-primary text-white">
  <i class="bi bi-clipboard-data"></i> Absensi & Jawaban Siswa
 </div>

<div class="card-body table-responsive">
  <table class="table table-bordered table-striped align-middle">
   <thead class="table-light text-center">
    <tr>
     <th>No</th>
     <th>Siswa</th>
     <th>Kelas</th>
     <th>Mapel</th>
     <th>Materi</th>
     <th>Soal</th>
     <th>Kunci Jawaban</th>
     <th>Jawaban Siswa</th>
     <th>Status</th>
     <th>Waktu</th>
    </tr>
   </thead>
   <tbody>

   <?php if(mysqli_num_rows($q)==0){ ?>

    <tr>
     <td colspan="10" class="text-center text-muted">
      Tidak ada data
     </td>
    </tr>

   <?php } else {
    $no = 1;
    while($r = mysqli_fetch_assoc($q)){

      // ===== LOGIKA BENAR / SALAH (TEKS vs TEKS)
      $kunci = strtolower(trim($r['kunci_jawaban'] ?? ''));
      $jawab = strtolower(trim($r['jawaban_siswa'] ?? ''));
      $isBenar = ($kunci !== '' && $jawab === $kunci);
   ?>

    <tr>
     <td class="text-center"><?= $no++ ?></td>

     <td><?= htmlspecialchars($r['nama_siswa']) ?></td>

     <td class="text-center">
       <?= htmlspecialchars($r['kelas_label']) ?>
     </td>

     <td><?= htmlspecialchars($r['nama_mapel']) ?></td>

     <td><?= htmlspecialchars($r['judul_materi']) ?></td>

     <td><?= nl2br(htmlspecialchars($r['pertanyaan'])) ?></td>

     <td class="fw-bold text-primary">
       <?= htmlspecialchars($r['kunci_jawaban'] ?? '-') ?>
     </td>

     <td>
       <?= htmlspecialchars($r['jawaban_siswa']) ?>
     </td>

     <td class="text-center">
      <?= $isBenar
        ? '<span class="badge badge-benar">Benar</span>'
        : '<span class="badge badge-salah">Salah</span>' ?>
     </td>

     <td class="text-center">
      <?= date('d-m-Y H:i', strtotime($r['dijawab_pada'])) ?>
     </td>
    </tr>

   <?php } } ?>

   </tbody>
  </table>
</div>
</div>

</div>


<div class="footer">
 © <?= date('Y') ?> PKBM Taruna Qurani • Sistem E-Learning
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
