<?php
session_start();
date_default_timezone_set("Asia/Jakarta");

/* ================= KONEKSI ================= */
$conn = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn){
    die("Koneksi database gagal");
}

/* ================= CEK LOGIN ================= */
if(empty($_SESSION['siswa_id'])){
    die("<h3 style='text-align:center;margin-top:50px'>Siswa belum login</h3>");
}

$siswa_id = intval($_SESSION['siswa_id']);

/* ================= AMBIL DATA SISWA ================= */
$qSiswa = mysqli_query($conn,"
    SELECT s.id, s.nama, s.kelas_id, k.nama_kelas
    FROM siswa s
    JOIN kelas k ON s.kelas_id = k.id
    WHERE s.id = '$siswa_id'
    LIMIT 1
");

if(mysqli_num_rows($qSiswa) == 0){
    die("<h3 style='text-align:center;margin-top:50px'>Data siswa tidak ditemukan</h3>");
}

$siswa = mysqli_fetch_assoc($qSiswa);
$kelas_id = $siswa['kelas_id'];

/* ================= AMBIL MEETING LIVE ================= */
$qMeet = mysqli_query($conn,"
    SELECT z.id, z.link_zoom, z.waktu_mulai, z.waktu_selesai,
           t.nama_tutor
    FROM zoom_meeting z
    JOIN tutor t ON z.tutor_id = t.id
    WHERE z.kelas_id = '$kelas_id'
    AND z.status='live'
    AND NOW() BETWEEN z.waktu_mulai AND z.waktu_selesai
    ORDER BY z.waktu_mulai DESC
    LIMIT 1
");

$meeting = mysqli_fetch_assoc($qMeet);
?>

<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Zoom Meeting</title>

<style>
body{
    font-family:Segoe UI;
    margin:0;
    background:#f4f6f9;
    text-align:center;
    padding:25px
}
.card{
    background:#fff;
    padding:25px;
    border-radius:14px;
    box-shadow:0 4px 12px rgba(0,0,0,.1);
    max-width:420px;
    margin:auto;
}
button{
    padding:12px 20px;
    background:#28a745;
    color:#fff;
    border:none;
    border-radius:8px;
    cursor:pointer;
    margin-top:15px;
    font-size:15px
}
button:hover{ opacity:.9 }
.live{ color:red; font-weight:bold }
video,canvas{ display:none }
</style>
</head>
<body>

<?php if(!$meeting): ?>

    <h3 class="live">🔴 Tidak ada Zoom yang sedang LIVE</h3>

<?php else: ?>

<div class="card">
    <h3 class="live">🔴 LIVE - <?= htmlspecialchars($meeting['nama_tutor']) ?></h3>
    <p>Kelas: <?= htmlspecialchars($siswa['nama_kelas']) ?></p>
    <p>
        <?= date("d M Y H:i", strtotime($meeting['waktu_mulai'])) ?>
        -
        <?= date("H:i", strtotime($meeting['waktu_selesai'])) ?>
    </p>

    <button onclick="startZoom()">Masuk Zoom & Presensi</button>
</div>

<video id="video" autoplay playsinline></video>
<canvas id="canvas"></canvas>

<script>
let latitude = null;
let longitude = null;

/* ================= GPS ================= */
if(navigator.geolocation){
    navigator.geolocation.getCurrentPosition(
        function(position){
            latitude  = position.coords.latitude;
            longitude = position.coords.longitude;
        },
        function(){
            alert("GPS wajib diaktifkan untuk presensi.");
        }
    );
}

/* ================= START ZOOM ================= */
async function startZoom(){

    if(latitude === null || longitude === null){
        alert("Menunggu GPS aktif...");
        return;
    }

    if(!navigator.mediaDevices){
        alert("Browser tidak mendukung kamera");
        return;
    }

    try{

        const video  = document.getElementById('video');
        const canvas = document.getElementById('canvas');

        const stream = await navigator.mediaDevices.getUserMedia({video:true});
        video.srcObject = stream;

        setTimeout(() => {

            canvas.width  = video.videoWidth;
            canvas.height = video.videoHeight;

            const ctx = canvas.getContext('2d');
            ctx.drawImage(video,0,0);

            let image = canvas.toDataURL("image/png");

            stream.getTracks().forEach(track => track.stop());

            kirimPresensi(image);

        },1500);

    }catch(err){
        alert("Kamera tidak diizinkan!");
    }
}

/* ================= KIRIM DATA ================= */
function kirimPresensi(image){

    fetch("presensi_zoom.php",{
        method:"POST",
        headers:{'Content-Type':'application/json'},
        body:JSON.stringify({
            meeting_id: "<?= intval($meeting['id']) ?>",
            image:image,
            latitude:latitude,
            longitude:longitude
        })
    })
    .then(res=>res.text())
    .then(res=>{

        if(res.trim() === "OK"){

            window.open("<?= htmlspecialchars($meeting['link_zoom']) ?>","_blank");

        }else{
            alert("Presensi gagal atau sudah pernah absen.");
        }

    })
    .catch(()=>{
        alert("Terjadi kesalahan sistem");
    });
}
</script>

<?php endif; ?>

</body>
</html>
