<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login_siswa']) || empty($_SESSION['siswa']['id'])) {
    header("Location: login_siswa.php");
    exit;
}

$siswa_id = (int)$_SESSION['siswa']['id'];
$kelas_id = (int)$_SESSION['siswa']['kelas_id'];
$tanggal  = date('Y-m-d');

/* ================= DATA MAPEL + STATUS ABSEN ================= */
$q = mysqli_query($conn,"
SELECT 
  m.id AS mapel_id,
  m.nama_mapel,
  p.id AS presensi_id,
  p.status,
  p.jam,
  p.foto
FROM kelas_mengajar km
JOIN mapel m ON m.id = km.mapel_id
LEFT JOIN presensi p 
  ON p.mapel_id = m.id 
 AND p.siswa_id = $siswa_id
 AND p.tanggal = '$tanggal'
WHERE km.kelas_id = $kelas_id
ORDER BY m.nama_mapel ASC
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Absen Harian</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body {
    background: #f1f4f9;
    padding-bottom: 70px; /* ruang untuk footer */
}

/* Foto absen */
.foto-absen {
    width: 45px;
    height: 45px;
    object-fit: cover;
    border-radius: 6px;
}

/* Badge */
.badge-hadir {
    background-color: #198754;
}

/* Tabel responsif untuk HP */
.table-responsive {
    overflow-x: auto;
}

/* Card */
.card {
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,.08);
}

/* Footer Nav */
.footer-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
    border-top:1px solid #ddd;
    display: flex;
    justify-content: space-around;
    padding: 6px 0;
    z-index: 999;
}
.footer-nav a {
    text-decoration: none;
    color: #333;
    font-size: 12px;
    text-align: center;
}
.footer-nav i {
    font-size: 20px;
    display: block;
}

/* Navbar */
.navbar-brand i {
    margin-right: 5px;
}

/* Tombol absen responsif */
.btn-sm {
    font-size: 0.75rem;
    padding: 0.35rem 0.5rem;
}
</style>
</head>
<body>

<!-- NAVBAR -->
<nav class="navbar navbar-dark bg-primary shadow">
 <div class="container-fluid">
  <span class="navbar-brand fw-bold">
   <i class="bi bi-mortarboard-fill"></i> ABSENSI SISWA
  </span>
 </div>
</nav>

<div class="container mt-3">

<div class="card shadow-sm">
<div class="card-body p-0">

<div class="table-responsive">
<table class="table table-hover mb-0 align-middle text-center">
<thead class="table-primary">
<tr>
 <th>#</th>
 <th class="text-start">Mapel</th>
 <th>Status</th>
 <th>Jam</th>
 <th>Foto</th>
 <th>Aksi</th>
</tr>
</thead>
<tbody>
<?php
$no = 1;
if(mysqli_num_rows($q) == 0):
?>
<tr>
<td colspan="6" class="text-center text-muted py-3">Tidak ada mapel</td>
</tr>
<?php endif; ?>

<?php while($d = mysqli_fetch_assoc($q)): ?>
<tr>
 <td><?= $no++ ?></td>
 <td class="text-start"><?= htmlspecialchars($d['nama_mapel']) ?></td>
 <td>
 <?php if($d['status']=='hadir'): ?>
   <span class="badge badge-hadir">Hadir</span>
 <?php else: ?>
   <span class="badge bg-secondary">Belum</span>
 <?php endif; ?>
 </td>
 <td><?= $d['jam'] ? date('H:i', strtotime($d['jam'])) : '-' ?></td>
 <td>
 <?php if($d['foto']): ?>
   <img src="../uploads/absen/<?= $d['foto'] ?>" class="foto-absen" alt="Foto Absen">
 <?php else: ?>
   -
 <?php endif; ?>
 </td>
 <td>
 <?php if($d['status']!='hadir'): ?>
   <a href="absen.php?mapel_id=<?= $d['mapel_id'] ?>" class="btn btn-success btn-sm">
     <i class="bi bi-camera"></i> Absen
   </a>
 <?php else: ?>
   <button class="btn btn-secondary btn-sm" disabled>
     <i class="bi bi-check-circle"></i>
   </button>
 <?php endif; ?>
 </td>
</tr>
<?php endwhile; ?>
</tbody>
</table>
</div>

</div>
</div>
</div>

<!-- FOOTER NAV -->
<div class="footer-nav">
 <a href="dashboard.php"><i class="bi bi-house"></i>Home</a>
 <a href="absen_list.php"><i class="bi bi-camera"></i>Absen</a>
 <a href="materi.php"><i class="bi bi-book"></i>Materi</a>
 <a href="elearning.php"><i class="bi bi-laptop"></i>E-Learning</a>
 <a href="#"><i class="bi bi-journal-check"></i>Ujian</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
