<?php
session_start();
require '../config/database.php';

$username = trim($_POST['username'] ?? '');
$password = trim($_POST['password'] ?? '');

if ($username == '' || $password == '') {
    header("Location: login_siswa.php?error=Lengkapi Username dan Password");
    exit;
}

/* ================= AMBIL DATA SISWA ================= */
$stmt = mysqli_prepare($conn,"
    SELECT s.*, k.nama_kelas, p.nama AS paket
    FROM siswa s
    LEFT JOIN kelas k ON k.id = s.kelas_id
    LEFT JOIN paket p ON k.paket_id = p.id
    WHERE s.username = ?
    LIMIT 1
");
mysqli_stmt_bind_param($stmt, "s", $username);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$siswa = mysqli_fetch_assoc($result);

/* ================= VALIDASI USER ================= */
if (!$siswa) {
    header("Location: login_siswa.php?error=Username tidak ditemukan");
    exit;
}

/* ================= CEK PASSWORD ================= */
if (!password_verify($password, $siswa['password'])) {
    header("Location: login_siswa.php?error=Password salah");
    exit;
}

/* ================= SESSION SISWA ================= */
$_SESSION['login_siswa'] = true;
$_SESSION['siswa'] = [
    'id'        => $siswa['id'],
    'nisn'      => $siswa['nisn'],
    'nama'      => $siswa['nama'],
    'kelas_id'  => $siswa['kelas_id'],
    'kelas'     => $siswa['nama_kelas'],
    'paket'     => $siswa['paket']
];

/* ================= REDIRECT DASHBOARD SISWA ================= */
header("Location: ../siswa/dashboard.php");
exit;
