<?php
session_start();
require '../config/database.php';

$username = trim($_POST['username'] ?? '');
$password = $_POST['password'] ?? '';

if ($username == '' || $password == '') {
    header("Location: login.php");
    exit;
}

/* ================= AMBIL USER ================= */
$stmt = mysqli_prepare($conn,"
    SELECT * FROM users
    WHERE username = ?
    LIMIT 1
");
mysqli_stmt_bind_param($stmt, "s", $username);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$user = mysqli_fetch_assoc($result);

/* ================= VALIDASI ================= */
if (!$user) {
    echo "<script>alert('Username tidak ditemukan');location='login.php';</script>";
    exit;
}

if (!password_verify($password, $user['password'])) {
    echo "<script>alert('Password salah');location='login.php';</script>";
    exit;
}

/* ================= SESSION ================= */
$_SESSION['login'] = true;
$_SESSION['user']  = [
    'id'   => $user['id'],
    'nama' => $user['nama'],
    'role' => $user['role']
];

/* ================= REDIRECT ================= */
if ($user['role'] == 'admin') {
    header("Location: ../admin/dashboard.php");
} elseif ($user['role'] == 'tutor') {
    header("Location: ../tutor/dashboard.php");
} else {
    header("Location: ../siswa/dashboard.php");
}
exit;
