<?php
session_start();
require '../config/database.php';

if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$page_title = 'Data Tutor';
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= $page_title ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
/* ================= GLOBAL ================= */
body{
 background:#f4f6f9;
 margin:0;
 overflow-x:hidden;
 font-family:system-ui,-apple-system,"Segoe UI",Roboto;
}

/* ================= SIDEBAR DESKTOP ================= */
.sidebar-desktop{
 position:fixed;
 top:0;
 left:0;
 width:260px;
 height:100vh;
 background:#0b1c2d;
 color:#fff;
 z-index:1030;
}
.sidebar-desktop .logo{
 text-align:center;
 padding:20px 10px;
}
.sidebar-desktop img{
 width:70px;
 margin-bottom:8px;
}
.sidebar-desktop a{
 display:flex;
 align-items:center;
 gap:10px;
 color:#fff;
 text-decoration:none;
 padding:10px 18px;
 margin:4px 10px;
 border-radius:8px;
}
.sidebar-desktop a:hover{
 background:rgba(255,255,255,.15);
}

/* ================= SIDEBAR MOBILE ================= */
.sidebar-mobile{
 background:#0b1c2d;
 color:#fff;
}
.sidebar-mobile-header{
 background:linear-gradient(135deg,#0d6efd,#0b1c2d);
}
.sidebar-logo{
 width:42px;
 height:42px;
 background:#fff;
 border-radius:10px;
 padding:4px;
}
.sidebar-item{
 display:flex;
 align-items:center;
 gap:14px;
 padding:12px 14px;
 border-radius:14px;
 color:#fff;
 text-decoration:none;
 margin-bottom:6px;
}
.sidebar-item:hover{
 background:rgba(255,255,255,.15);
}
.sidebar-item.logout{
 background:rgba(255,0,0,.15);
}

/* ================= TOPBAR ================= */
.topbar{
 position:fixed;
 top:0;
 left:260px;
 right:0;
 height:56px;
 background:#fff;
 border-bottom:1px solid #ddd;
 z-index:1500;
 display:flex;
 align-items:center;
 padding:0 16px;
}

/* ================= MAIN CONTENT ================= */
.main-content{
 margin-left:260px;
 padding-top:72px;
 padding-bottom:70px;
 min-height:100vh;
 background:#f4f6f9;
}

/* pembungkus isi */
.container-body{
 max-width:1200px;
 margin:auto;
 padding:24px;
}

/* ================= FOOTER ================= */
footer{
 position:fixed;
 bottom:0;
 left:260px;
 right:0;
 background:#fff;
 border-top:1px solid #ddd;
 text-align:center;
 font-size:14px;
 padding:8px;
 z-index:1400;
}

/* ================= OFFCANVAS FIX ================= */
.offcanvas{
 z-index:1600;
}

/* ================= KOMPONEN ================= */
.foto-tutor{
 width:38px;
 height:38px;
 border-radius:50%;
 object-fit:cover;
 border:1px solid #ddd;
}
.btn-action{
 width:34px;
 height:34px;
 padding:0;
}

/* ================= MOBILE & TABLET ================= */
@media(max-width:991px){

 .sidebar-desktop{
  display:none;
 }

 .topbar{
  left:0;
 }

 .main-content{
  margin-left:0;
  padding-top:64px;
  padding-bottom:20px;
 }

 .container-body{
  padding:3px 0px; /* 👈 INI KUNCI */
 }

 footer{
  left:0;
 }
}
</style>

</head>

<body>
  <!-- ===== SIDEBAR MOBILE ===== -->
<div class="offcanvas offcanvas-start sidebar-mobile d-lg-none"
     tabindex="-1"
     id="sidebarMobile">

 <div class="offcanvas-header sidebar-mobile-header">
  <div class="d-flex align-items-center gap-2">
   <img src="../assets/img/logo.jpg" class="sidebar-logo">
   <div>
    <div class="fw-bold">PKBM TARUNA QURANI</div>
    <small class="opacity-75">Admin Panel</small>
   </div>
  </div>
  <button type="button"
          class="btn-close btn-close-white"
          data-bs-dismiss="offcanvas"></button>
 </div>

 <div class="offcanvas-body">
  <a href="dashboard.php" class="sidebar-item">
   <i class="bi bi-speedometer2"></i> Dashboard
  </a>
  <a href="siswa.php" class="sidebar-item">
   <i class="bi bi-people"></i> Siswa
  </a>
  <a href="kelas.php" class="sidebar-item">
   <i class="bi bi-diagram-3"></i> Kelas
  </a>
  <a href="tutor.php" class="sidebar-item">
   <i class="bi bi-person-badge"></i> Tutor
  </a>
  <a href="mapel.php" class="sidebar-item">
   <i class="bi bi-book"></i> Mapel
  </a>
  <a href="materi.php" class="sidebar-item">
   <i class="bi bi-journal-text"></i> Materi
  </a>

  <hr>

  <a href="../auth/logout.php" class="sidebar-item logout">
   <i class="bi bi-box-arrow-right"></i> Logout
  </a>
 </div>
</div>


<!-- SIDEBAR DESKTOP -->
<div class="sidebar-desktop d-none d-lg-block">
 <div class="logo">
  <img src="../assets/img/logo.jpg">
  <h6 class="fw-bold">PKBM TARUNA QURANI</h6>
 </div>
 <a href="dashboard.php"><i class="bi bi-speedometer2"></i> Dashboard</a>
 <a href="siswa.php"><i class="bi bi-people"></i> Siswa</a>
 <a href="kelas.php"><i class="bi bi-diagram-3"></i> Kelas</a>
 <a href="tutor.php" style="background:rgba(255,255,255,.25)"><i class="bi bi-person-badge"></i> Tutor</a>
 <a href="mapel.php"><i class="bi bi-book"></i> Mapel</a>
 <a href="materi.php"><i class="bi bi-journal-text"></i> Materi</a>
 <hr>
 <a href="../auth/logout.php" class="text-warning"><i class="bi bi-box-arrow-right"></i> Logout</a>
</div>

<!-- TOPBAR -->
<div class="topbar">
 <button class="btn btn-outline-primary d-lg-none"
         data-bs-toggle="offcanvas"
         data-bs-target="#sidebarMobile">
  <i class="bi bi-list"></i>
 </button>

 <span class="fw-semibold ms-2"><?= $page_title ?></span>
 <span class="ms-auto fw-semibold">
  <?= htmlspecialchars($_SESSION['user']['nama'] ?? 'Admin') ?>
 </span>
</div>

<!-- MAIN -->
<div class="main-content">
 <div class="container-body">

  <div class="content-card p-4">

   <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="mb-0">
     <i class="bi bi-person-badge"></i> Daftar Tutor
    </h5>
    <button class="btn btn-primary"
            data-bs-toggle="modal"
            data-bs-target="#modalTambah">
     <i class="bi bi-plus-circle"></i> Tambah
    </button>
   </div>

   <div class="table-responsive">
    <table class="table table-bordered table-hover align-middle">
     <thead class="table-dark text-center">
      <tr>
       <th>Foto</th>
       <th>Nama</th>
       <th>Email</th>
       <th>No HP</th>
       <th>Pendidikan</th>
       <th>KTP</th>
       <th>Ijazah</th>
       <th>Aksi</th>

      </tr>
     </thead>
     <tbody>
     <?php
     $q=mysqli_query($conn,"
 SELECT tutor.id tutor_id, users.nama, users.username,
       tutor.email, tutor.no_hp, tutor.pendidikan, 
       tutor.foto, tutor.foto_ktp, tutor.foto_ijazah

 FROM tutor 
 JOIN users ON tutor.user_id=users.id 
 WHERE users.role='tutor'
");

     if(mysqli_num_rows($q)==0){
      echo '<tr><td colspan="6" class="text-center text-muted">Belum ada tutor</td></tr>';
     }
     while($d=mysqli_fetch_assoc($q)){
      $foto = (!empty($d['foto']) && file_exists("../uploads/tutor/".$d['foto'])) ? $d['foto'] : 'default.png';
     ?>
      <tr>
 <td class="text-center">
  <img src="../uploads/tutor/<?= $foto ?>" class="foto-tutor">
 </td>
 <td><?= htmlspecialchars($d['nama']) ?></td>
 <td><?= htmlspecialchars($d['email']) ?></td>
 <td><?= htmlspecialchars($d['no_hp']) ?></td>
 <td><?= htmlspecialchars($d['pendidikan']) ?></td>

 <td class="text-center">
  <?php if(!empty($d['foto_ktp']) && file_exists("../uploads/ktp/".$d['foto_ktp'])){ ?>
   <a href="../uploads/ktp/<?= $d['foto_ktp'] ?>" target="_blank" class="btn btn-sm btn-info">
    <i class="bi bi-card-image"></i>
   </a>
  <?php } else { echo '-'; } ?>
 </td>

 <td class="text-center">
  <?php if(!empty($d['foto_ijazah']) && file_exists("../uploads/ijazah/".$d['foto_ijazah'])){ ?>
   <a href="../uploads/ijazah/<?= $d['foto_ijazah'] ?>" target="_blank" class="btn btn-sm btn-success">
    <i class="bi bi-card-image"></i>
   </a>
  <?php } else { echo '-'; } ?>
 </td>

 <td class="text-center">
  <button class="btn btn-warning btn-sm btn-action btn-edit"
   data-id="<?= $d['tutor_id'] ?>"
   data-nama="<?= htmlspecialchars($d['nama'],ENT_QUOTES) ?>"
   data-username="<?= htmlspecialchars($d['username'],ENT_QUOTES) ?>"
   data-email="<?= htmlspecialchars($d['email'],ENT_QUOTES) ?>"
   data-hp="<?= htmlspecialchars($d['no_hp'],ENT_QUOTES) ?>"
   data-pendidikan="<?= htmlspecialchars($d['pendidikan'],ENT_QUOTES) ?>">
   <i class="bi bi-pencil"></i>
  </button>

  <button class="btn btn-danger btn-sm btn-action btn-hapus"
   data-id="<?= $d['tutor_id'] ?>">
   <i class="bi bi-trash"></i>
  </button>
 </td>
</tr>

     <?php } ?>
     </tbody>
    </table>
   </div>

  </div>

 </div>
</div>


<footer>© <?= date('Y') ?> Team PKBM Taruna Qurani</footer>

<!-- MODAL TAMBAH -->
<div class="modal fade" id="modalTambah">
 <div class="modal-dialog modal-dialog-centered">
  <form method="post" action="tutor_proses.php" enctype="multipart/form-data" class="modal-content">
   <input type="hidden" name="aksi" value="tambah">
   <div class="modal-header"><h5>Tambah Tutor</h5></div>
   <div class="modal-body">
    <input name="nama" class="form-control mb-2" placeholder="Nama" required>
    <input name="username" class="form-control mb-2" placeholder="Username" required>
    <input name="password" class="form-control mb-2" placeholder="Password" required>
    <input name="pendidikan" class="form-control mb-2" placeholder="Pendidikan">
    <input name="email" type="email" class="form-control mb-2" placeholder="Email">
    <input name="no_hp" class="form-control mb-2" placeholder="No HP">
    <input type="file" name="foto" class="form-control">
    <label class="mt-2">Foto KTP</label>
<input type="file" name="foto_ktp" class="form-control">

<label class="mt-2">Foto Ijazah</label>
<input type="file" name="foto_ijazah" class="form-control">

   </div>
   <div class="modal-footer">
    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
    <button class="btn btn-primary">Simpan</button>
   </div>
  </form>
 </div>
</div>

<!-- MODAL EDIT & HAPUS -->
<div class="modal fade" id="modalEdit" tabindex="-1">
 <div class="modal-dialog modal-dialog-centered">
  <form method="post" action="tutor_proses.php"
        enctype="multipart/form-data"
        class="modal-content">

   <input type="hidden" name="aksi" value="edit">
   <input type="hidden" name="id" id="edit_id">

   <div class="modal-header">
    <h5 class="modal-title">Edit Tutor</h5>
    <button class="btn-close" data-bs-dismiss="modal"></button>
   </div>

   <div class="modal-body">
    <input class="form-control mb-2" name="nama" id="edit_nama" placeholder="Nama">
    <input class="form-control mb-2" name="email" id="edit_email" placeholder="Email">
    <input class="form-control mb-2" name="no_hp" id="edit_hp" placeholder="No HP">
    <input class="form-control mb-2" name="pendidikan" id="edit_pendidikan" placeholder="Pendidikan">
    <input class="form-control mb-2" name="username" id="edit_username" placeholder="Username">

<input class="form-control mb-2" name="password" id="edit_password" placeholder="Password Baru (opsional)">
<small class="text-muted d-block mb-2">
 Kosongkan jika tidak ingin mengubah password
</small>

    <input type="file" class="form-control" name="foto">
    <label class="mt-2">Update Foto KTP</label>
<input type="file" class="form-control" name="foto_ktp">

<label class="mt-2">Update Foto Ijazah</label>
<input type="file" class="form-control" name="foto_ijazah">

   </div>

   <div class="modal-footer">
    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
    <button class="btn btn-warning">Update</button>
   </div>

  </form>
 </div>
</div>

<!-- ================= MODAL HAPUS ================= -->
<div class="modal fade" id="modalHapus" tabindex="-1">
 <div class="modal-dialog modal-dialog-centered">
  <form method="post" action="tutor_proses.php" class="modal-content">

   <input type="hidden" name="aksi" value="hapus">
   <input type="hidden" name="id" id="hapus_id">

   <div class="modal-header bg-danger text-white">
    <h5 class="modal-title">
     <i class="bi bi-trash"></i> Hapus Guru
    </h5>
    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
   </div>

   <div class="modal-body text-center">
    <p class="mb-1 fw-semibold">Yakin ingin menghapus tutor ini?</p>
    <small class="text-muted">Data yang dihapus tidak dapat dikembalikan.</small>
   </div>

   <div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
     Batal
    </button>
    <button class="btn btn-danger">
     <i class="bi bi-trash"></i> Hapus
    </button>
   </div>

  </form>
 </div>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded',()=>{
 document.querySelectorAll('.btn-edit').forEach(b=>{
  b.onclick=()=>{
   edit_id.value=b.dataset.id
   edit_nama.value=b.dataset.nama
   edit_username.value=b.dataset.username
   edit_email.value=b.dataset.email
   edit_hp.value=b.dataset.hp
   edit_pendidikan.value=b.dataset.pendidikan
   edit_password.value=''   // kosongkan setiap buka modal
   new bootstrap.Modal(modalEdit).show()
  }
 })
 document.querySelectorAll('.btn-hapus').forEach(b=>{
  b.onclick=()=>{
   hapus_id.value=b.dataset.id
   new bootstrap.Modal(modalHapus).show()
  }
 })
})
</script>



</body>
</html>
