<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= HELPER UPLOAD ================= */
function uploadMateri($tipe)
{
    if (!isset($_FILES['file']) || $_FILES['file']['error'] !== 0) {
        return null;
    }

    $folder = "../materi_upload/$tipe/";
    if (!is_dir($folder)) {
        mkdir($folder, 0777, true);
    }

    $namaAsli = $_FILES['file']['name'];
    $ext = strtolower(pathinfo($namaAsli, PATHINFO_EXTENSION));

    $allowed = $tipe === 'pdf'
        ? ['pdf']
        : ['mp4', 'mkv', 'avi', 'mov'];

    if (!in_array($ext, $allowed)) {
        die("Tipe file tidak sesuai dengan jenis materi ($tipe)");
    }

    $namaBaru = time() . '_' . rand(1000, 9999) . '.' . $ext;
    $tujuan   = $folder . $namaBaru;

    if (!move_uploaded_file($_FILES['file']['tmp_name'], $tujuan)) {
        die("Gagal upload file");
    }

    return $namaBaru;
}

/* ================= MODE ================= */
$aksi = $_POST['aksi'] ?? $_GET['aksi'] ?? '';

/* ================= TAMBAH ================= */
if ($aksi === 'tambah') {

    $judul    = trim($_POST['judul'] ?? '');
    $mapel_id = (int)($_POST['mapel_id'] ?? 0);
    $tipe     = $_POST['tipe'] ?? 'pdf';
    $kelas    = $_POST['kelas'] ?? [];

    if (!$judul || !$mapel_id || !$tipe || empty($kelas)) {
        die("Data belum lengkap");
    }

    $file = uploadMateri($tipe);
    if (!$file) die("File wajib diupload");

    $tutor_id = (int)($_SESSION['user']['id'] ?? 0);

    mysqli_begin_transaction($conn);

    try {

        mysqli_query($conn, "
          INSERT INTO materi (judul, mapel_id, tutor_id, tipe, file, created_at)
          VALUES (
            '".mysqli_real_escape_string($conn,$judul)."',
            $mapel_id,
            $tutor_id,
            '".mysqli_real_escape_string($conn,$tipe)."',
            '".mysqli_real_escape_string($conn,$file)."',
            NOW()
          )
        ");

        $materi_id = mysqli_insert_id($conn);

        foreach ($kelas as $kid) {
            $kid = (int)$kid;
            mysqli_query($conn, "
              INSERT INTO materi_kelas (materi_id, kelas_id)
              VALUES ($materi_id, $kid)
            ");
        }

        mysqli_commit($conn);

        header("Location: materi.php?msg=added");
        exit;

    } catch (Exception $e) {
        mysqli_rollback($conn);
        die("Gagal simpan materi: " . $e->getMessage());
    }
}

/* ================= EDIT ================= */
if ($aksi === 'edit') {

    $id       = (int)($_POST['id'] ?? 0);
    $judul    = trim($_POST['judul'] ?? '');
    $mapel_id = (int)($_POST['mapel_id'] ?? 0);
    $tipe     = $_POST['tipe'] ?? 'pdf';
    $kelas    = $_POST['kelas'] ?? [];

    if (!$id || !$judul || !$mapel_id || !$tipe || empty($kelas)) {
        die("Data belum lengkap");
    }

    $fileBaru = null;
    if (isset($_FILES['file']) && $_FILES['file']['error'] === 0) {
        $fileBaru = uploadMateri($tipe);

        // hapus file lama
        $old = mysqli_fetch_assoc(mysqli_query($conn,"SELECT file, tipe FROM materi WHERE id=$id"));
        if ($old && $old['file']) {
            @unlink("../materi_upload/{$old['tipe']}/{$old['file']}");
        }
    }

    mysqli_begin_transaction($conn);

    try {

        if ($fileBaru) {
            mysqli_query($conn, "
              UPDATE materi SET
                judul='".mysqli_real_escape_string($conn,$judul)."',
                mapel_id=$mapel_id,
                tipe='".mysqli_real_escape_string($conn,$tipe)."',
                file='".mysqli_real_escape_string($conn,$fileBaru)."'
              WHERE id=$id
            ");
        } else {
            mysqli_query($conn, "
              UPDATE materi SET
                judul='".mysqli_real_escape_string($conn,$judul)."',
                mapel_id=$mapel_id,
                tipe='".mysqli_real_escape_string($conn,$tipe)."'
              WHERE id=$id
            ");
        }

        mysqli_query($conn, "DELETE FROM materi_kelas WHERE materi_id=$id");

        foreach ($kelas as $kid) {
            $kid = (int)$kid;
            mysqli_query($conn, "
              INSERT INTO materi_kelas (materi_id, kelas_id)
              VALUES ($id, $kid)
            ");
        }

        mysqli_commit($conn);

        header("Location: materi.php?msg=updated");
        exit;

    } catch (Exception $e) {
        mysqli_rollback($conn);
        die("Gagal update materi: " . $e->getMessage());
    }
}

/* ================= HAPUS ================= */
if ($aksi === 'hapus') {

    $id = (int)($_GET['id'] ?? 0);
    if (!$id) die("ID tidak valid");

    $old = mysqli_fetch_assoc(mysqli_query($conn,"SELECT file, tipe FROM materi WHERE id=$id"));
    if ($old && $old['file']) {
        @unlink("../materi_upload/{$old['tipe']}/{$old['file']}");
    }

    mysqli_begin_transaction($conn);

    try {
        mysqli_query($conn, "DELETE FROM materi_kelas WHERE materi_id=$id");
        mysqli_query($conn, "DELETE FROM materi_baca WHERE materi_id=$id");
        mysqli_query($conn, "DELETE FROM soal WHERE materi_id=$id");
        mysqli_query($conn, "DELETE FROM materi WHERE id=$id");

        mysqli_commit($conn);

        header("Location: materi.php?msg=deleted");
        exit;

    } catch (Exception $e) {
        mysqli_rollback($conn);
        die("Gagal hapus materi: " . $e->getMessage());
    }
}

/* ================= DEFAULT ================= */
die("Aksi tidak dikenal");
