<?php
session_start();
require_once __DIR__ . '/../config/database.php';

if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

// Ambil data tutor, kelas, mapel sekaligus
$tutorList = mysqli_query($conn,"SELECT id, nama FROM users WHERE role='tutor' ORDER BY nama ASC");
$kelasList = mysqli_query($conn,"
    SELECT k.id, k.nama_kelas, p.nama AS paket
    FROM kelas k
    LEFT JOIN paket p ON k.paket_id = p.id
    ORDER BY k.nama_kelas
");
$mapelList = mysqli_query($conn,"SELECT id, nama_mapel FROM mapel ORDER BY nama_mapel");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Jadwal Mengajar</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9}
.main-content{
    margin-left:260px;
    padding:20px;
}
@media(max-width:768px){
    .main-content{margin-left:0}
}
.card{
    border-radius:16px;
    box-shadow:0 6px 18px rgba(0,0,0,.08);
}
</style>
</head>
<body>

<!-- NAVBAR HP -->
<nav class="navbar navbar-dark bg-dark sticky-top d-md-none">
  <div class="container-fluid">
    <button class="btn btn-outline-light" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
      <i class="bi bi-list"></i>
    </button>
    <span class="navbar-brand">Jadwal Mengajar</span>
  </div>
</nav>

<?php require_once __DIR__ . '/partials/sidebar.php'; ?>

<div class="main-content">
<div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="fw-bold"><i class="bi bi-calendar-week"></i> Jadwal Mengajar</h5>
    <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
        <i class="bi bi-plus-circle"></i> Tambah
    </button>
</div>

<div class="card p-3">
<div class="table-responsive">
<table class="table table-bordered table-hover align-middle small">
<thead class="table-dark text-center">
<tr>
    <th>Tutor</th>
    <th>Kelas</th>
    <th>Mapel</th>
    <th>Hari</th>
    <th>Jam</th>
    <th width="90">Aksi</th>
</tr>
</thead>
<tbody>

<?php
$q = mysqli_query($conn,"
    SELECT j.*, u.nama AS tutor, k.nama_kelas, p.nama AS paket, m.nama_mapel
    FROM jadwal j
    JOIN users u ON j.tutor_id = u.id
    JOIN kelas k ON j.kelas_id = k.id
    LEFT JOIN paket p ON k.paket_id = p.id
    JOIN mapel m ON j.mapel_id = m.id
    ORDER BY j.hari, j.jam_mulai
");

if(mysqli_num_rows($q)==0){
    echo '<tr><td colspan="6" class="text-center text-muted">Belum ada jadwal</td></tr>';
}

while($d=mysqli_fetch_assoc($q)){
    $kelasFull = $d['nama_kelas'] . ($d['paket'] ? ' - '.$d['paket'] : '');
?>
<tr>
<td><?= htmlspecialchars($d['tutor']) ?></td>
<td><?= htmlspecialchars($kelasFull) ?></td>
<td><?= htmlspecialchars($d['nama_mapel']) ?></td>
<td class="text-center"><?= $d['hari'] ?></td>
<td class="text-center"><?= $d['jam_mulai'] ?> - <?= $d['jam_selesai'] ?></td>
<td class="text-center">
    <button class="btn btn-warning btn-sm btn-edit"
        data-id="<?= $d['id'] ?>"
        data-tutor="<?= $d['tutor_id'] ?>"
        data-kelas="<?= $d['kelas_id'] ?>"
        data-mapel="<?= $d['mapel_id'] ?>"
        data-hari="<?= $d['hari'] ?>"
        data-mulai="<?= $d['jam_mulai'] ?>"
        data-selesai="<?= $d['jam_selesai'] ?>">
        <i class="bi bi-pencil"></i>
    </button>
    <button class="btn btn-danger btn-sm btn-hapus"
        data-id="<?= $d['id'] ?>">
        <i class="bi bi-trash"></i>
    </button>
</td>
</tr>
<?php } ?>

</tbody>
</table>
</div>
</div>
</div>

<!-- ================= MODAL TAMBAH ================= -->
<div class="modal fade" id="modalTambah">
<div class="modal-dialog modal-lg modal-dialog-centered">
<form method="post" action="jadwal_proses.php" class="modal-content">
<input type="hidden" name="aksi" value="tambah">

<div class="modal-header">
<h5 class="modal-title">Tambah Jadwal</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body row g-3">
<div class="col-md-6">
<label class="form-label">Tutor</label>
<select name="tutor_id" class="form-select" required>
<?php mysqli_data_seek($tutorList,0);
while($r = mysqli_fetch_assoc($tutorList)){
    echo "<option value='{$r['id']}'>{$r['nama']}</option>";
} ?>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Kelas</label>
<select name="kelas_id" class="form-select" required>
<?php mysqli_data_seek($kelasList,0);
while($r = mysqli_fetch_assoc($kelasList)){
    $paket = $r['paket'] ? ' - '.$r['paket'] : '';
    echo "<option value='{$r['id']}'>{$r['nama_kelas']}{$paket}</option>";
} ?>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Mapel</label>
<select name="mapel_id" class="form-select" required>
<?php mysqli_data_seek($mapelList,0);
while($r = mysqli_fetch_assoc($mapelList)){
    echo "<option value='{$r['id']}'>{$r['nama_mapel']}</option>";
} ?>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Hari</label>
<select name="hari" class="form-select" required>
<option value="Senin">Senin</option>
<option value="Selasa">Selasa</option>
<option value="Rabu">Rabu</option>
<option value="Kamis">Kamis</option>
<option value="Jumat">Jumat</option>
<option value="Sabtu">Sabtu</option>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Jam Mulai</label>
<input type="time" name="jam_mulai" class="form-control" required>
</div>

<div class="col-md-6">
<label class="form-label">Jam Selesai</label>
<input type="time" name="jam_selesai" class="form-control" required>
</div>

</div>
<div class="modal-footer">
<button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
<button class="btn btn-primary">Simpan</button>
</div>
</form>
</div>
</div>

<!-- ================= MODAL EDIT ================= -->
<div class="modal fade" id="modalEdit">
<div class="modal-dialog modal-lg modal-dialog-centered">
<form method="post" action="jadwal_proses.php" class="modal-content">
<input type="hidden" name="aksi" value="edit">
<input type="hidden" name="id" id="edit_id">

<div class="modal-header">
<h5 class="modal-title">Edit Jadwal</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body row g-3">

<div class="col-md-6">
<label class="form-label">Tutor</label>
<select name="tutor_id" id="edit_tutor" class="form-select" required>
<?php mysqli_data_seek($tutorList,0);
while($r = mysqli_fetch_assoc($tutorList)){
    echo "<option value='{$r['id']}'>{$r['nama']}</option>";
} ?>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Kelas</label>
<select name="kelas_id" id="edit_kelas" class="form-select" required>
<?php mysqli_data_seek($kelasList,0);
while($r = mysqli_fetch_assoc($kelasList)){
    $paket = $r['paket'] ? ' - '.$r['paket'] : '';
    echo "<option value='{$r['id']}'>{$r['nama_kelas']}{$paket}</option>";
} ?>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Mapel</label>
<select name="mapel_id" id="edit_mapel" class="form-select" required>
<?php mysqli_data_seek($mapelList,0);
while($r = mysqli_fetch_assoc($mapelList)){
    echo "<option value='{$r['id']}'>{$r['nama_mapel']}</option>";
} ?>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Hari</label>
<select name="hari" id="edit_hari" class="form-select" required>
<option value="Senin">Senin</option>
<option value="Selasa">Selasa</option>
<option value="Rabu">Rabu</option>
<option value="Kamis">Kamis</option>
<option value="Jumat">Jumat</option>
<option value="Sabtu">Sabtu</option>
</select>
</div>

<div class="col-md-6">
<label class="form-label">Jam Mulai</label>
<input type="time" name="jam_mulai" id="edit_mulai" class="form-control" required>
</div>

<div class="col-md-6">
<label class="form-label">Jam Selesai</label>
<input type="time" name="jam_selesai" id="edit_selesai" class="form-control" required>
</div>

</div>
<div class="modal-footer">
<button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
<button class="btn btn-warning">Update</button>
</div>
</form>
</div>
</div>

<!-- ================= MODAL HAPUS ================= -->
<div class="modal fade" id="modalHapus">
<div class="modal-dialog modal-dialog-centered">
<form method="post" action="jadwal_proses.php" class="modal-content">
<input type="hidden" name="aksi" value="hapus">
<input type="hidden" name="id" id="hapus_id">
<div class="modal-header bg-danger text-white">
<h5 class="modal-title">Hapus Jadwal</h5>
</div>
<div class="modal-body text-center">
Yakin ingin menghapus jadwal ini?
</div>
<div class="modal-footer">
<button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
<button class="btn btn-danger">Hapus</button>
</div>
</form>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
const edit_id = document.getElementById('edit_id');
const edit_tutor = document.getElementById('edit_tutor');
const edit_kelas = document.getElementById('edit_kelas');
const edit_mapel = document.getElementById('edit_mapel');
const edit_hari = document.getElementById('edit_hari');
const edit_mulai = document.getElementById('edit_mulai');
const edit_selesai = document.getElementById('edit_selesai');
const hapus_id = document.getElementById('hapus_id');

document.querySelectorAll('.btn-edit').forEach(btn=>{
 btn.onclick=()=>{
   edit_id.value = btn.dataset.id;
   edit_tutor.value = btn.dataset.tutor;
   edit_kelas.value = btn.dataset.kelas;
   edit_mapel.value = btn.dataset.mapel;
   edit_hari.value = btn.dataset.hari;
   edit_mulai.value = btn.dataset.mulai;
   edit_selesai.value = btn.dataset.selesai;
   new bootstrap.Modal(modalEdit).show();
 }
});

document.querySelectorAll('.btn-hapus').forEach(btn=>{
 btn.onclick=()=>{
   hapus_id.value = btn.dataset.id;
   new bootstrap.Modal(modalHapus).show();
 }
});
</script>

</body>
</html>
