<?php
session_start();

// koneksi database
$host = "localhost";
$user = "root";
$pass = "";
$db   = "pkbm_taruna_qurani";

$conn = mysqli_connect($host, $user, $pass, $db);
if (!$conn) die("Koneksi gagal: " . mysqli_connect_error());


// ambil semua ebook guru
$ebooksGuru = mysqli_query($conn, "SELECT * FROM ebook WHERE kategori='guru' ORDER BY id DESC");

// base URL folder ebook
$baseURL = '/pkbm-test/edu_digital/admin/ebook_file/';

// ================= DEFAULT =================
$logoSekolah = '/pkbm-test/edu_digital/assets/img/logo.PNG';
$namaSekolah = 'DHARMANANDA AGUNG ACADEMY';

// ================= AMBIL DATA PKBM =================
$q = mysqli_query($conn,"SELECT logo, nama_sekolah FROM pkbm LIMIT 1");
if($q && mysqli_num_rows($q) > 0){
    $s = mysqli_fetch_assoc($q);

    // LOGO
    if(!empty($s['logo'])){
        $fileServer = __DIR__ . '/../edu_digital/assets/img/' . $s['logo'];
        if(is_file($fileServer)){
            $logoSekolah = '/pkbm-test/edu_digital/assets/img/' . $s['logo'];
        }
    }

    // NAMA SEKOLAH
    if(!empty(trim($s['nama_sekolah']))){
        $namaSekolah = htmlspecialchars($s['nama_sekolah']);
    }
}

?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>E-Book Guru</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body { 
    background: #f0f2f5; 
    font-family: 'Segoe UI', sans-serif; 
    padding-top: 20px; 
    padding-bottom: 70px; /* agar konten tidak tertutup bottom nav */
}

.card { 
    border-radius: 12px; 
    transition: .3s; 
    cursor: pointer; 
}
.card:hover { 
    transform: translateY(-5px); 
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}

.card-title { font-size: 1.1rem; font-weight: 600; }
.badge { font-size: .8rem; }
h3 { font-weight: 700; color: #2c3e50; }
.btn-back { margin-bottom: 20px; }

/* BINGKAI BACA */
#bingkaiBaca {
    margin-top: 30px;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 0 10px rgba(0,0,0,0.2);
    padding: 10px;
    min-height: 400px;
}
#bingkaiBaca iframe, #bingkaiBaca video {
    width: 100%;
    height: 80vh;
}

/* ===== BOTTOM NAV ===== */
.bottom{
    position: fixed;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 56px;
    background: #0b1c2d;
    display: flex;
    justify-content: space-around;
    align-items: center;
    color: #fff;
    font-size: 14px;
    z-index: 1050;
}
.bottom a{
    color: #fff;
    text-decoration: none;
    display: flex;
    flex-direction: column;
    align-items: center;
    font-size: 12px;
    transition: 0.2s;
}
.bottom a i{
    font-size: 18px;
    margin-bottom: 2px;
}
.bottom a:hover{
    color: #0d6efd;
}
/* ===== TOPBAR PRO FIX ===== */
.topbar{
  position: fixed;
  top:0;
  left:0;
  width:100%;
  z-index:1100;
  background:linear-gradient(45deg,#0b1c2d,#0d6efd);
  padding:8px 0;
  box-shadow:0 4px 14px rgba(0,0,0,.18);
}


.topbar .container-fluid{
  min-height:54px;
  display:flex;
  align-items:center;
}

.topbar-logo{
  height:48px;
  width:auto;
  object-fit:contain;
  background:#fff;
  padding:1px;
  border-radius:8px;
}

.topbar-title{
  color:#fff;
  font-weight:600;
  font-size:1rem;
  line-height:1.15;
  white-space:nowrap;
}

/* JUDUL HALAMAN */
.page-title{
  margin-top:60px;
  margin-bottom:15px;
  text-align:center;
  font-weight:700;
  color:#0b1c2d;
}


/* RESPONSIVE */
@media(max-width:576px){
  .topbar{
    padding:6px 0;
  }

  .topbar-logo{
    height:34px;
  }

  .topbar-title{
    font-size:.9rem;
  }
}

</style>
</head>
<body>

  <!-- TOPBAR -->
<div class="topbar">
  <div class="container-fluid px-3">

    <div class="d-flex align-items-center gap-2">
      <img src="<?= $logoSekolah ?>" class="topbar-logo">
      <span class="topbar-title"><?= $namaSekolah ?></span>
    </div>

  </div>
</div>

<h3 class="page-title">📚 E-Book Guru</h3>

    <!-- ===== GRID E-BOOK ===== -->
    <div class="row g-4">
    <?php if(mysqli_num_rows($ebooksGuru) > 0): ?>
        <?php while($r = mysqli_fetch_assoc($ebooksGuru)): ?>
            <div class="col-12 col-md-6 col-lg-4">
                <div class="card shadow-sm">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?= htmlspecialchars($r['judul']) ?></h5>
                        <p class="card-text"><?= htmlspecialchars($r['deskripsi']) ?></p>
                        <div class="mt-auto d-flex justify-content-between align-items-center">
                            <a href="<?= $baseURL . $r['jenis'] . '/' . $r['file'] ?>" download class="btn btn-success btn-sm">
                                <i class="bi bi-download"></i> Download
                            </a>
                            <button class="btn btn-primary btn-sm" onclick="bacaEbook('<?= $r['file'] ?>','<?= $r['jenis'] ?>')">
                                <i class="bi bi-book"></i> Baca
                            </button>
                        </div>
                        <div class="mt-2">
                            <span class="badge bg-info text-dark"><?= strtoupper($r['jenis']) ?></span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p class="text-muted">Belum ada E-Book untuk guru.</p>
    <?php endif; ?>
    </div>

    <!-- ===== BINGKAI BACA ===== -->
    <div id="bingkaiBaca">
        <p class="text-center text-muted">Klik "Baca" pada E-Book untuk menampilkan di sini.</p>
    </div>

</div>

<!-- ===== BOTTOM NAV ===== -->
<div class="bottom">
    <a href="/pkbm-test/index.html"><i class="bi bi-house"></i>Home</a>
  <a href="/pkbm-test/jadwal_guru.php"><i class="bi bi-calendar-event"></i>Jadwal</a>
  <a href="#"><i class="bi bi-chat"></i>Chat</a>
  <a href="#"><i class="bi bi-person"></i>Profil</a>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
const baseURL = '<?= $baseURL ?>';

function bacaEbook(file, jenis){
    const bingkai = document.getElementById('bingkaiBaca');
    let html = '';

    if(jenis === 'pdf'){
        html = `<iframe src="${baseURL}pdf/${encodeURIComponent(file)}#view=FitH" style="width:100%;height:80vh;border:none;"></iframe>`;
    }
    else if(jenis === 'word'){
        const url = encodeURIComponent(`${baseURL}word/${file}`);
        html = `<iframe src="https://docs.google.com/gview?url=${url}&embedded=true" style="width:100%;height:80vh;border:none;"></iframe>`;
    }
    else if(jenis === 'video'){
        html = `<video controls autoplay style="width:100%;height:80vh;">
                    <source src="${baseURL}video/${encodeURIComponent(file)}" type="video/mp4">
                    Browser tidak mendukung video ini.
                </video>`;
    }
    else {
        html = `<p class="text-center p-4">File tidak dapat dibaca di browser. Silakan download.</p>`;
    }

    bingkai.innerHTML = html;
    bingkai.scrollIntoView({behavior: "smooth"});
}
</script>

</body>
</html>
